% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{compare_n_qualvars}
\alias{compare_n_qualvars}
\title{Comparison for columns of factors for more than 2 groups with post-hoc}
\usage{
compare_n_qualvars(
  data,
  dep_vars,
  indep_var,
  round_p = 3,
  round_desc = 2,
  pretext = FALSE,
  mark = FALSE,
  singleline = FALSE,
  spacer = "&nbsp;",
  linebreak = "\\n",
  prettynum = FALSE
)
}
\arguments{
\item{data}{name of data set (tibble/data.frame) to analyze.}

\item{dep_vars}{vector of column names.}

\item{indep_var}{name of grouping variable.}

\item{round_p}{level for rounding p-value.}

\item{round_desc}{number of significant digits for rounding of descriptive stats}

\item{pretext}{for function \link{formatP}}

\item{mark}{for function \link{formatP}}

\item{singleline}{Put all group levels in  a single line?}

\item{spacer}{Text element to indent levels, defaults to " ".}

\item{linebreak}{place holder for newline.}

\item{prettynum}{Apply prettyNum to results?}
}
\value{
A tibble with variable names, descriptive statistics, and p-value of \link{fisher.test}
and \link{pairwise_fisher_test}, number of rows is number of dep_vars.
}
\description{
Comparison for columns of factors for more than 2 groups with post-hoc
}
\examples{
# Separate lines for each factor level:
compare_n_qualvars(
  data = mtcars, dep_vars = c("am", "cyl", "carb"), indep_var = "gear",
  spacer = " "
)
# All levels in one row but with linebreaks:
compare_n_qualvars(
  data = mtcars, dep_vars = c("am", "cyl", "carb"), indep_var = "gear",
  singleline = TRUE
)
# All levels in one row, separateted by ";":
compare_n_qualvars(
  data = mtcars, dep_vars = c("am", "cyl", "carb"), indep_var = "gear",
  singleline = TRUE, linebreak = "; "
)
}
