% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggcormat}
\alias{ggcormat}
\title{Print graphical representation of a correlation matrix.}
\usage{
ggcormat(
  cor_mat,
  p_mat = NULL,
  method = "Correlation",
  title = "",
  maxpoint = 2.1,
  textsize = 5,
  axistextsize = 2,
  titlesize = 3,
  breaklabels = NULL,
  lower_only = TRUE,
  .low = "blue3",
  .high = "red2",
  .legendtitle = NULL
)
}
\arguments{
\item{cor_mat}{correlation matrix as produced by cor.}

\item{p_mat}{Optional matrix of p-values; if provided, this is used to define
size of dots rather than absolute correlation.}

\item{method}{text specifying type of correlation.}

\item{title}{plot title.}

\item{maxpoint}{maximum for scale_size_manual, may need adjustment depending on plotsize.}

\item{textsize}{for theme text.}

\item{axistextsize}{relative text size for axes.}

\item{titlesize}{as you already guessed, relative text size for title.}

\item{breaklabels}{currently not used, intended for str_wrap.}

\item{lower_only}{should only lower triangle be plotted?}

\item{.low}{Color for heatmap.}

\item{.high}{Color for heatmap.}

\item{.legendtitle}{Optional name for color legend.}
}
\value{
A ggplot object, allowing further styling.
}
\description{
Print graphical representation of a correlation matrix.
}
\examples{
coeff_pvalues <- cortestR(mtcars[, c("wt", "mpg", "qsec", "hp")],
  split = TRUE, sign_symbol = FALSE
)
# focus on coefficients:
ggcormat(cor_mat = coeff_pvalues$corout, maxpoint = 5)
# size take from p-value:
ggcormat(
  cor_mat = coeff_pvalues$corout,
  p_mat = coeff_pvalues$pout, maxpoint = 5
)
}
