% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNTheor.R
\name{plotNTheor}
\alias{plotNTheor}
\title{Plot the number of theoretical random fragments}
\usage{
plotNTheor(
  x,
  tit = "Number of term and intern fragm",
  xlab = "Number of aa",
  ylab = "",
  col = 2:3,
  log = "",
  mark = NULL,
  cexMark = 0.75
)
}
\arguments{
\item{x}{(integer) length (in amino-acids) of input peptides/proteins to be considered}

\item{tit}{(character) custom title}

\item{xlab}{(character) custom x-axis label}

\item{ylab}{(character) custom y-axis label}

\item{col}{(character or integer) cutsom colors}

\item{log}{(character) define which axis should be log (use "xy" for drawing both x- and y-axis as log-scale)}

\item{mark}{(matrix) first column for text and second column for where it should be stated along the top border of the figure (x-coordinate)}

\item{cexMark}{(numeric) cex expansion-factor for text from argument \code{mark}}
}
\value{
figure only
}
\description{
This simple function allows plotting the expected number of theoretical fragments from random fragmentation of peptides/proteins (in mass spectrometry).
Here, only the pure fragmentation without any variable fragmentation is considered, all fragment-sizes are included (ie, no gating). 
For simplicity, possible (variable) modifications like loss of neutrals, etc, are not considered.
}
\examples{
marks <- data.frame(name=c("Ubiquitin\n76aa", "Glutamate dehydrogenase 1\n501aa"),
  length=c(76,501))
plotNTheor(x=20:750, log="", mark=marks)
}
\seealso{
\code{\link{AAfragSettings}}
}
