% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlSpecCharConv.R
\name{htmlSpecCharConv}
\alias{htmlSpecCharConv}
\title{Html Special Character Conversion}
\usage{
htmlSpecCharConv(txt, silent = FALSE, callFrom = NULL, debug = FALSE)
}
\arguments{
\item{txt}{character vector, including special characters}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function returns a corrected character vector adopted for html display
}
\description{
Converts 'txt' so that (the most common) special characters (like 'beta','micro','square' etc) will be displayed correctly whe used for display in html (eg at mouse-over).
Note : The package \href{https://CRAN.R-project.org/package=stringi}{stringi} is required for the conversions (the input will get returned if \code{stringi} is not available).
Currently only the 16 most common special characters are implemented.
}
\examples{
## we'll use the package stringi to generate text including the 'micro'-symbol as input
x <- if(requireNamespace("stringi", quietly=TRUE)) {
  stringi::stri_unescape_unicode("\\\\u00b5\\\\u003d\\\\u0061\\\\u0062")} else "\"x=axb\""
htmlSpecCharConv(x)
}
\seealso{
tables on \url{https://www.htmlhelp.com/reference/html40/entities/latin1.html},  
  \url{https://www.degraeve.com/reference/specialcharacters.php}, or \code{https://ascii.cl/htmlcodes.htm}
}
