% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFilePath.R
\name{checkFilePath}
\alias{checkFilePath}
\title{Check If File Is Available For Reading}
\usage{
checkFilePath(
  fileName,
  path,
  expectExt = "",
  compressedOption = TRUE,
  strictExtension = FALSE,
  stopIfNothing = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fileName}{(character) name of file to be tested; may also include an absolute or relative path}

\item{path}{(character, length=1) optional separate entry for path of \code{fileName}}

\item{expectExt}{(character) file extension (will not be considerd if \code{""})}

\item{compressedOption}{(logical) also look for .gz compressed files}

\item{strictExtension}{(logical) decide if extesion (\code{expectExt}) - if given - should be considered obligatory}

\item{stopIfNothing}{(logical) decide if function should give error or warning if no files found}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a character vector with verified path and file-name(s), returns \code{NULL} if nothing
}
\description{
This function allows tesing if a given file-name corresponds to an existing file (eg for reading lateron).
Indications to the path and file-extensions may be given separately. If no files do match .gz compressed versions may be searced, too.
}
\details{
When the filename given by the user exists but it's file-extension is not matching \code{expectExt} 
the argument \code{strictExtension} allows to decide if the filename will still be returned or not.

When \code{expectExt} is given, initial search will look for perfect matches. 
However, if nothing is found and \code{strictExtension=FALSE}, a more relaxed and non-case-sensitive search will be performed.
}
\examples{
(RhomeFi <- list.files(R.home()))
file.exists(file.path(R.home(), "bin"))
checkFilePath(c("xxx","unins000"), R.home(), expectExt="dat")
}
\seealso{
\code{\link[base]{file.exists}}
}
