% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustUnitPrefix.R
\name{adjustUnitPrefix}
\alias{adjustUnitPrefix}
\title{Adjust Value With Different Decimal Prefixes To Single Prefix Plus Unit}
\usage{
adjustUnitPrefix(
  x,
  pref = c("z", "a", "f", "p", "n", "u", "m"),
  unit = "sec",
  sep = c(".", " ", ""),
  headingTxt = "",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) vector containing digit uunit-prefix and unit terms}

\item{pref}{(character) multiplicative unit-prefixes, assumes as increasing factors of 1000}

\item{unit}{(character) unit name, the numeric part may be sepatated by one space-character}

\item{sep}{(character) separator characters that may appear between integer numeric value and unit description}

\item{headingTxt}{(character) additional text preceeding the numeric part of 'x' to be ingnored/removed}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector with quantities extracted and adjusted to a single type of unit (without the unit description)
}
\description{
This function provides help converting values with with different unit-prefixes to a single prefix-unit type.
This can be used to convert a vector of mixed prefixes like 'p' and 'n'.
Any text to the right of the unit will be ignored.
}
\details{
Please note that the current version recognizes and converts only interger values, decimals or scientific writing won't work.
The resultant numeric vector expresses all values as lowest prefix unit level.
In case of invalid entries \code{NA}s will be returned.

Please note the 'u' is used for 'micro'.
}
\examples{
adjustUnitPrefix(c("10.psec abc","2 fsec etc"), unit="sec")
}
\seealso{
\code{\link{convToNum}}
}
