% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMatrixLinesToRef.R
\name{matchMatrixLinesToRef}
\alias{matchMatrixLinesToRef}
\title{Match All Lines of Matrix To Reference}
\usage{
matchMatrixLinesToRef(
  mat,
  ref,
  addRef = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{mat}{(matrix or data.frame) main input, all columns of of \code{mat} will be tested for (partial) matching of \code{ref}}

\item{ref}{(character) reference for trying to match each of the columns of  \code{mat}}

\item{addRef}{(logical), if \code{TRUE} the content of \code{ref} will be added to  \code{mat} as additional column}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns the input matrix in an adjusted order (plus an optional additional column showing the reference)
}
\description{
This function allows adjusting the order of lines of a matrix \code{mat} to a reference character-vector \code{ref},
even when initial direct matching of character-strings using \code{match} is not possible/successful.
In this case, various variants of using \code{grep} will be used to see if unambiguous matching is possible of characteristic parts of the text.
All columns of \code{mat} will be tested an the column giving the bes resuts will be used.
}
\details{
This function tests all columns of \code{mat} to see which one gives the best matching results to the reference \code{ref}.
In case no direct matching is possible, \code{grep} will be used to find the best partial matching.
The orderof the rows of input \code{mat} will be adjusted according to the matching results.

If \code{addRef=TRUE}, the reference will be included as additional column to the results, too.
}
\examples{
mat1 <- matrix(paste0("__",letters[rep(c(1,1,2,2,3),3) +rep(0:2,each=5)], rep(1:5)), ncol=3)
matchMatrixLinesToRef(mat1, paste0(letters[c(3,4,5,3,4)],c(1,3,5,2,4)))

mat2 <- matrix(paste0("__",letters[rep(c(1,1,2,2,3),3) +rep(0:2,each=5)],
  c(rep(1:5,2),1,1,3:5 )), ncol=3)
matchMatrixLinesToRef(mat2, paste0(letters[c(3,4,5,3,4)],c(1,3,5,1,4)))

mat3 <- matrix(paste0(letters[rep(c(1,1,2,2,3),3) +rep(0:2,each=5)],
  c(rep(1:5,2),1,1,3,3,5) ), ncol=3)
matchMatrixLinesToRef(mat3, paste0("__",letters[c(3,4,5,3,4)],c(1,3,5,1,3)))



}
\seealso{
\code{\link[base]{match}},  \code{\link[base]{grep}}, \code{\link{replicateStructure}}
}
