% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_classify.R
\name{workpatterns_classify}
\alias{workpatterns_classify}
\title{Classify working pattern personas using a rule based algorithm}
\usage{
workpatterns_classify(
  data,
  hrvar = "Organization",
  values = "percent",
  signals = "email",
  start_hour = "0900",
  end_hour = "1700",
  active_threshold = 0,
  method = "bw",
  return = "plot"
)
}
\arguments{
\item{data}{A data frame containing data from the Hourly Collaboration query.}

\item{hrvar}{A string specifying the HR attribute to cut the data by.
Defaults to NULL. This only affects the function when "table" is returned,
and is only applicable for method = "bw".}

\item{values}{Only valid if using \code{pav} method. Character vector to specify
whether to return percentages or absolute values in "data" and "plot".
Valid values are "percent" (default) and "abs".}

\item{signals}{Character vector to specify which collaboration metrics to
use:
\itemize{
\item \code{"email"} (default) for emails only
\item \code{"IM"} for Teams messages only
\item \code{"unscheduled_calls"} for Unscheduled Calls only
\item \code{"meetings"} for Meetings only
\item or a combination of signals, such as \code{c("email", "IM")}
}}

\item{start_hour}{A character vector specifying starting hours, e.g. "0900".
Note that this currently only supports \strong{hourly} increments.}

\item{end_hour}{A character vector specifying starting hours, e.g. "1700".
Note that this currently only supports \strong{hourly} increments.}

\item{active_threshold}{A numeric value specifying the minimum number of
signals to be greater than in order to qualify as \emph{active}. Defaults to 0.
Only applicable for the binary-week method.}

\item{method}{String to pass through specifying which method to use for
classification. By default, a binary week-based (bw) method is used, with
options to use the the person-average volume-based (pav) method.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"data"}
\item \code{"table"}
\item \code{"plot-area"}
}

See \code{Value} for more information.}
}
\value{
Character vector to specify what to return. Valid options
include:
\itemize{
\item \code{"plot"}: returns a heatmap plot of signal distribution by hour
and archetypes (default)
\item \code{"data"}: returns the raw data with the classified archetypes
\item \code{"table"}: returns a summary table of the archetypes
\item \code{"plot-area"}: returns an area plot of the percentages of archetypes
shown over time
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Apply a rule based algorithm to emails or instant messages sent by hour of
day. Uses a binary week-based ('bw') method by default, with options to use
the the person-average volume-based ('pav') method.
}
\details{
This is a wrapper around \code{workpatterns_classify_bw()} and
\code{workpatterns_classify_pav()}, and calls each function depending on what is
supplied to the \code{method} argument. Both methods implement a rule-based
classification of either \strong{person-weeks} or \strong{persons} that pull apart
different working patterns.

See individual sections below for details on the two different
implementations.
}
\section{Binary Week method}{


This method classifies each \strong{person-week} into one of the seven
archetypes:
\itemize{
\item 0 < 3 hours on
\item 1 Standard with breaks workday
\item 2 Standard continuous workday
\item 3 Standard flexible workday
\item 4 Long flexible workday
\item 5 Long continuous workday
\item 6 Always on (13h+)
}

This is the recommended method over \code{pav} for several reasons:
\enumerate{
\item \code{bw} ignores \emph{volume effects}, where activity volume can still bias the
results towards the 'standard working hours'.
\item It captures the intuition that each individual can have 'light' and
'heavy' weeks with respect to workload.
}
}

\section{Person Average method}{


This method classifies each \strong{person} (based on unique \code{PersonId}) into
one of the six archetypes:
\itemize{
\item Absent
\item Extended Hours - Morning
\item Extended Hours - Evening
\item Overnight workers
\item Standard Hours
\item Always On
}
}

\section{Flexibility Index}{
 The Working Patterns archetypes as calculated
using the binary-week method shares many similarities with the Flexibility
Index (see \code{flex_index()}): - Both are computed directly from the Hourly
Collaboration Flexible Query. - Both apply the same binary conversion of
activity on the signals from the Hourly Collaboration Flexible Query.
}

\examples{

# Returns a plot by default
em_data \%>\% workpatterns_classify(method = "bw")

# Return an area plot
em_data \%>\% workpatterns_classify(method = "bw", return = "plot-area")

\donttest{

em_data \%>\% workpatterns_classify(method = "bw", return = "table")

em_data \%>\% workpatterns_classify(method = "pav")

em_data \%>\% workpatterns_classify(method = "pav", return = "plot-area")

}

}
\seealso{
Other Clustering: 
\code{\link{personas_hclust}()},
\code{\link{workpatterns_hclust}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Clustering}
\concept{Working Patterns}
