% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_records_common.R
\name{wm_records_common}
\alias{wm_records_common}
\title{Get records by vernacular name, optional fuzzy matching}
\usage{
wm_records_common(name, fuzzy = FALSE, offset = 1, ...)
}
\arguments{
\item{name}{(character) a species common name. required.}

\item{fuzzy}{(logical) fuzzy search. default: \code{FALSE}}

\item{offset}{(integer) record to start at. default: 1}

\item{...}{named curl options. see \code{\link[curl]{curl_options}}}
}
\description{
Get records by vernacular name, optional fuzzy matching
}
\examples{
wm_records_common(name = 'dolphin')
wm_records_common(name = 'clam')

\dontrun{
wm_records_common(name = 'dolphin', fuzzy = TRUE)
wm_records_common(name = 'clam', fuzzy = TRUE, offset = 5)
}
}

