% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_corpus_ungd2017}
\alias{data_corpus_ungd2017}
\title{UN General Debate speeches from 2017}
\format{
The corpus includes the following document variables: \describe{
\item{country_iso}{ISO3c country code, e.g. "AFG" for Afghanistan}
\item{un_session}{UN session, a numeric identifier (in this case, 72)}
\item{year}{4-digit year (2017).}
\item{country}{country name, in English.}
\item{continent}{continent of the country, one of: Africa, Americas, Asia,
Europe, Oceania. Note that the speech delivered on behalf of the
European Union is coded as "Europe".}
\item{gdp}{GDP in $US for 2017, from the World Bank. Contains missing
values for 9 countries.}
\item{gdp_per_capita}{GDP per capita in $US for 2017, derived from the
World Bank. Contains missing values for 9 countries.}
}
}
\source{
Mikhaylov, M., Baturo, A., & Dasandi, N. (2017). "United Nations
General Debate Corpus". doi:10.7910/DVN/0TJX8Y. Harvard Dataverse, V4.
}
\usage{
data_corpus_ungd2017
}
\description{
A corpus of 196 speeches from the 2017 UN General Debate (Mikhaylov and
Baturo, 2017). The economic data for 2017 (GDP and GDP per capita) are
downloaded from the World Bank website.
}
\references{
Baturo, A., Dasandi, N., & Mikhaylov, S. (2017). "Understanding
State Preferences With Text As Data: Introducing the UN General Debate
Corpus". doi:10.1177/2053168017712821. \emph{Research and Politics}.
}
\keyword{datasets}
