% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{open_data}
\alias{open_data}
\title{Use open data in WORCS project}
\usage{
open_data(
  data,
  filename = "data.csv",
  codebook = "codebook.Rmd",
  worcs_directory = ".",
  ...
)
}
\arguments{
\item{data}{A data.frame to save.}

\item{filename}{Character, naming the file data should be written to.}

\item{codebook}{Character, naming the file the codebook should be written to.
An 'R Markdown' codebook will be created and rendered to
\code{\link[rmarkdown]{github_document}} ('markdown' for 'GitHub').
Defaults to 'codebook.Rmd'. Set to \code{NULL} to avoid creating a codebook.}

\item{worcs_directory}{Character, indicating the WORCS project directory to
which to save data. The default value \code{"."} points to the current
directory.}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
Returns \code{NULL} invisibly. This
function is called for its side effects.
}
\description{
This function saves a data.frame as a \code{.csv} file (using
\code{\link[utils]{write.csv}}), stores a checksum in '.worcs',
and amends the \code{.gitignore} file to exclude \code{filename}.
}
\examples{
test_dir <- file.path(tempdir(), "data")
old_wd <- getwd()
dir.create(test_dir)
setwd(test_dir)
worcs:::write_worcsfile(".worcs")
open_data(iris[1:5, ], codebook = "bla.Rmd")
setwd(old_wd)
unlink(test_dir, recursive = TRUE)
}
\seealso{
open_data closed_data save_data
}
