library(wkb)
library(sp)
context("Conversion from WKB LineString representations")

# create an object of class SpatialLines
l1 <- data.frame(x = c(1, 2), y = c(3, 2))
l2 <- data.frame(x = c(1,2), y = c(1, 1.5))
Sl1 <- Line(l1)
Sl2 <- Line(l2)
S1 <- Lines(list(Sl1), ID = "1")
S2 <- Lines(list(Sl2), ID = "2")
refobj <- SpatialLines(list(S1, S2))

# create an AsIs list of little-endian WKB geometry representations of type LineString
refwkb <- I(list(
  as.raw(c(0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40)),
  as.raw(c(0x01, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f))
))

# create an AsIs list of big-endian WKB geometry representations of type LineString
refwkbbe <- I(list(
as.raw(c(0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x3f, 0xf0,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)),
as.raw(c(0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x3f, 0xf0,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00))
))

test_that("little-endian WKB LineString representation converts to SpatialLines object", {
  # convert little-endian WKB LineString representation to SpatialLines object
  obj <- readWKB(refwkb)

  # test
  expect_equal(obj, refobj)
})

test_that("big-endian WKB LineString representation converts to SpatialLines object", {
  # convert big-endian WKB LineString representation to SpatialLines object
  obj <- readWKB(refwkbbe)

  # test
  expect_equal(obj, refobj)
})
