% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dllog.R, R/llogSummaryStats.R, R/pllog.R,
%   R/qllog.R, R/rllog.R
\name{LogLogistic}
\alias{LogLogistic}
\alias{dllog}
\alias{pllog}
\alias{rllog}
\alias{llogSummaryStats}
\alias{qllog}
\title{Log-Logistic Distribution}
\usage{
dllog(x, shape = 1, scale = 1, log = FALSE, ...)

llogSummaryStats(shape, scale)

pllog(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE, ...)

qllog(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE, ...)

rllog(n, shape = 1, scale = 1, ...)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{shape}{Shape parameter.}

\item{scale}{Scale parameter.}

\item{log}{Logical; if TRUE, log densities are returned.}

\item{...}{Currently ignored.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x) otherwise, P(X > x).}

\item{log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dllog} returns vector of the densities.

\code{pllog} returns a vector of probabilities.

\code{qllog} returns a vector of quantiles.

\code{rllog} returns a vector of random log-logistic variates.
}
\description{
The probability density function, cumulative density function, inverse cumulative density function, random generation for the log logistic distribution.
}
\details{
If X is a random variable distributed according to a logistic distribution, then Y = exp(X) has a log-logistic distribution.

The log-logistic distribution with parameters \code{shape = a} and \code{scale = s} has density
\deqn{f(x) = \frac{(\frac{1}{a*exp(s))})(\frac{x}{\exp{s}})^{\frac{1}{a} - 1}}{(1+(\frac{x}{\exp{s}})^{1/a})^2}}
for \code{x >= 0}, \code{a > 1}, and \code{s > 0}.

The median is \code{exp(s)}, mean is
\deqn{\frac{a\pi*exp(s)}{sin(a*\pi)}}
for \code{1/a > 1}. The variance is
\deqn{(exp(s))^2(\frac{2*\pi*a}{(sin(2*pi*a))}- \frac{(a*\pi)^2}{(sin^2(a*\pi))})}
for \code{1/a > 2}. The mode is
\deqn{exp(s)(\frac{(1/a) - 1}{(1/a) + 1})^{a}}
for \code{1/a > 1} otherwise it is zero.
}
\examples{

y <- rllog(5,shape=1,scale=1/3)
dllog(x=y,shape=1,scale=1/3)
dlogis(x=log(y),location=1/3,scale=1)/y

pllog(q=y,shape=1,scale=1/3)
qllog(p=seq(0,1,by=.25),shape=1,scale=1/3)


}
\seealso{
\code{\link[stats]{dlogis}} \code{\link[stats]{plogis}} \code{\link[stats]{qlogis}} \code{\link[stats]{rlogis}}
}
