% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-diff.R
\name{get_diff}
\alias{get_diff}
\title{Search for insertions, deletions or relocations of text between two versions
of a Wikipedia page}
\usage{
get_diff(from, to, language = "en", simplify = TRUE)
}
\arguments{
\item{from}{Vector of revision ids}

\item{to}{Vector of revision ids}

\item{language}{Vector of two-letter language codes (will be recycled if
length==1)}

\item{simplify}{logical: should R simplify the result (see \link{return})}
}
\value{
The return value depends on the \code{simplify} parameter.
\itemize{
\item If \code{simplify} == TRUE: A list of \link[tibble:tbl_df-class]{tibble::tbl_df} objects the same
length as \code{from} and \code{to}. Most of the response data is stripped away,
leaving just the textual differences between the revisions, their location,
type and 'highlightRanges' if the textual differences are complicated.
\item If \code{simplify} == FALSE: A list the same length as \code{from} and \code{to}
containing the full \href{https://www.mediawiki.org/wiki/API:REST_API/Reference#Response_schema_3}{wikidiff2 response}
for each pair of revisions. This response includes additional data for
displaying diffs onscreen.
}
}
\description{
Any two revisions of a Wikipedia page can be compared using the 'diff' tool.
The tool compares the 'from' revision to the 'to' revision, looking for
insertions, deletions or relocations of text. This operation can be performed
in any order, across any span of revisions.
}
\examples{
# Compare revision 847170467 to 851733941 on English Wikipedia
get_diff(847170467, 851733941)

# The function is vectorised, so you can compare multiple pairs of revisions
# in a single call
# See diffs for the last two revisions of the Main Page
revisions <- wiki_action_request() \%>\%
  query_by_title("Main Page") \%>\%
  query_page_properties(
    "revisions",
    rvlimit = 2, rvprop = "ids", rvdir = "older"
  ) \%>\%
  gracefully(next_result)

if (tibble::is_tibble(revisions)) {
  revisions <- revisions \%>\%
    tidyr::unnest(cols = c(revisions)) \%>\%
    dplyr::mutate(diffs = get_diff(from = parentid, to = revid))

  print(revisions)
}

}
