% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_pmi.R
\name{pairwise_pmi}
\alias{pairwise_pmi}
\alias{pairwise_pmi_}
\title{Pointwise mutual information of pairs of items}
\usage{
pairwise_pmi(tbl, item, feature, sort = FALSE, ...)

pairwise_pmi_(tbl, item, feature, sort = FALSE, ...)
}
\arguments{
\item{tbl}{Table}

\item{item}{Item to compare; will end up in \code{item1} and
\code{item2} columns}

\item{feature}{Column describing the feature that links one item to others}

\item{sort}{Whether to sort in descending order of the pointwise mutual
information}

\item{...}{Extra arguments passed on to \code{squarely},
such as \code{diag} and \code{upper}}
}
\value{
A tbl_df with three columns, \code{item1}, \code{item2}, and
\code{pmi}.
}
\description{
Find pointwise mutual information of pairs of items in a column, based on
a "feature" column that links them together.
This is an example of the spread-operate-retidy pattern.
}
\examples{

library(dplyr)

dat <- data_frame(group = rep(1:5, each = 2),
                  letter = c("a", "b",
                             "a", "c",
                             "a", "c",
                             "b", "e",
                             "b", "f"))

# how informative is each letter about each other letter
pairwise_pmi(dat, letter, group)
pairwise_pmi(dat, letter, group, sort = TRUE)

}
