% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_convert.R
\name{sp_convert}
\alias{sp_convert}
\title{Convert SpatialPolygons or SpatialPolygonDataFrames into WKT objects}
\usage{
sp_convert(x, group = TRUE)
}
\arguments{
\item{x}{a list of SP/SPDF objects (or a single object)}

\item{group}{whether or not to group coordinates together in the case that an object
in \code{x} has multiple sets of coordinates. If TRUE (the default), such objects will
be returned as \code{MULTIPOLYGON}s - if FALSE, as a vector of \code{POLYGON}s.}
}
\value{
either a character vector of WKT objects - one per sp object - if \code{group} is TRUE,
or a list of vectors if \code{group} is FALSE.
}
\description{
\code{sp_convert} turns objects from the \code{sp} package -
specifically, SpatialPolygons and SpatialPolygonDataFrames - into WKT POLYGONs
or MULTIPOLYGONs
}
\examples{
\dontrun{
library(sp)
s1 <- SpatialPolygons(list(Polygons(list(Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))), "s1")))
sp_convert(s1)
}
}
\seealso{
\code{\link{bounding_wkt}}, for turning bounding boxes within \code{sp} objects
into WKT objects.
}
