% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_model.R
\name{rasch_model}
\alias{rasch_model}
\title{Run the Rasch Model and print diagnostic results}
\usage{
rasch_model(
  df,
  vars_metric,
  vars_id,
  print_results = FALSE,
  path_output = NULL,
  LIDcutoff = 0.2
)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_id}{a string with column name uniquely identifying individuals}

\item{print_results}{a logical value indicating whether or not to print various files displaying results from the Rasch Model. Default is FALSE, to not print the files.}

\item{path_output}{a string with the path to the output folder. Default is NULL.}

\item{LIDcutoff}{either a numeric value between 0 and 1 indicating the cut-off for significant local item dependence, or the string "christensen" to use the cut-off suggested by Christensen et al. 2017 (see reference). If "christensen" cut-off fails, defaults to 0.2.}
}
\value{
a list with results from the Rasch Model:
\item{model}{the results from the Rasch Model}
\item{df_score}{a tibble with the items used in the analysis and the person abilities}
\item{thresholds}{the item thresholds (i.e., crossings)}
\item{person_parameters}{person abilities}
\item{PSI}{the person-separation index}
\item{item_fit}{infit and outfit statistics per item}
\item{residuals_PCM}{the standardized person residuals}
\item{LID}{matrix with the item residual correlations}
\item{targeting}{a matrix with information on the targeting of the model}
\item{fit_results}{a string with results of the item fit}
\item{LID_results}{a string with results of the local item dependency}
\item{disordered_results}{a string listing items with disordered thresholds}
}
\description{
Run the Rasch Model and print diagnostic results
}
\details{
The Rasch Model is calculated using the function \code{eRm::PCM()}.
}
\references{
Christensen, K. B., Makransky, G., & Horton, M. (2017). Critical Values for Yen’s Q 3 : Identification of Local Dependence in the Rasch Model Using Residual Correlations.  Applied Psychological Measurement, 41(3), 178-194. \doi{10.1177/0146621616677520}
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{rasch functions}
