% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_rawscore.R
\name{rasch_rawscore}
\alias{rasch_rawscore}
\title{Add the raw scores to the data and artificial individuals attaining the minimum and/or maximum}
\usage{
rasch_rawscore(df, vars_metric, vars_id, max_values)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_id}{a string with column name uniquely identifying individuals}

\item{max_values}{a tibble with two columns, \code{var} equivalent to \code{vars_metric} and \code{max_val} with their corresponding maximum possible values}
}
\value{
a tibble with a new column \code{RawScore} with the raw sum score of \code{vars_metric} for each individual, and artificial rows with individuals that attain the minimum and/or maximum if either is not attained in \code{df}. The artificial maximum row has value "MAX" in the \code{vars_id} column, and likewise the artificial minimum row has the value "MIN" in this column.
}
\description{
Add the raw scores to the data and artificial individuals attaining the minimum and/or maximum
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{rasch functions}
