% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_topo_render}
\alias{wbt_topo_render}
\title{Topo render}
\usage{
wbt_topo_render(
  dem,
  output,
  palette = "soft",
  rev_palette = FALSE,
  az = 315,
  alt = 30,
  background_hgt_offset = 10,
  polygon = NULL,
  background_clr = "[255, 255, 255]",
  attenuation = 0.6,
  ambient_light = 0.2,
  z_factor = 1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input digital elevation model (DEM) raster file.}

\item{output}{Name of the output raster file.}

\item{palette}{Palette name; options are 'atlas', 'high_relief', 'arid', 'soft', 'earthtones', 'muted', 'light_quant', 'purple', 'viridi', 'gn_yl', 'pi_y_g', 'bl_yl_rd', 'deep', 'imhof', and 'white'.}

\item{rev_palette}{Reverse the palette?.}

\item{az}{Light source azimuth direction (degrees, 0-360).}

\item{alt}{Light source altitude (degrees, 0-90).}

\item{background_hgt_offset}{Offset height of background, in z-units.}

\item{polygon}{Clipping polygon vector file (optional).}

\item{background_clr}{Background red-green-blue (RGB) or red-green-blue-alpha (RGBA) colour, e.g. '\verb{[255, 255, 245]}', '\verb{[255, 255, 245, 200]}'.}

\item{attenuation}{Attenuation parameter. Range is 0-4. Zero means no attenuation.}

\item{ambient_light}{Ambient light parameter. Range is 0.0-0.7. Zero means no ambient light.}

\item{z_factor}{Elevation multiplier, or a vertical exageration.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates a pseudo-3D rendering from an input DEM, for the purpose of effective topographic visualization.
}
\keyword{GeomorphometricAnalysis}
