% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_network_analysis.R
\name{wbt_remove_short_streams}
\alias{wbt_remove_short_streams}
\title{Remove short streams}
\usage{
wbt_remove_short_streams(
  d8_pntr,
  streams,
  output,
  min_length,
  esri_pntr = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{d8_pntr}{Input raster D8 pointer file.}

\item{streams}{Input raster streams file.}

\item{output}{Output raster file.}

\item{min_length}{Minimum tributary length (in map units) used for network pruning.}

\item{esri_pntr}{D8 pointer uses the ESRI style scheme.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Removes short first-order streams from a stream network.
}
\keyword{StreamNetworkAnalysis}
