% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_classify_lidar}
\alias{wbt_classify_lidar}
\title{Classify lidar}
\usage{
wbt_classify_lidar(
  input,
  output = NULL,
  radius = 1.5,
  grd_threshold = 0.1,
  oto_threshold = 2,
  planarity_threshold = 0.85,
  linearity_threshold = 0.7,
  iterations = 30,
  facade_threshold = 0.5,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR points.}

\item{output}{Name of the output LiDAR points.}

\item{radius}{Search distance used in neighbourhood search (metres).}

\item{grd_threshold}{Ground threshold (metres).}

\item{oto_threshold}{Off-terrain object threshold (metres).}

\item{planarity_threshold}{Planarity threshold (0-1).}

\item{linearity_threshold}{Linearity threshold (0-1).}

\item{iterations}{Number of iterations.}

\item{facade_threshold}{Facade threshold (metres).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Classify points within a LiDAR point cloud based on point properties.
}
\keyword{LiDARTools}
