% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{wbt_weighted_overlay}
\alias{wbt_weighted_overlay}
\title{Weighted overlay}
\usage{
wbt_weighted_overlay(
  factors,
  weights,
  output,
  cost = NULL,
  constraints = NULL,
  scale_max = 1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{factors}{Input factor raster files.}

\item{weights}{Weight values, contained in quotes and separated by commas or semicolons. Must have the same number as factors.}

\item{output}{Output raster file.}

\item{cost}{Weight values, contained in quotes and separated by commas or semicolons. Must have the same number as factors.}

\item{constraints}{Input constraints raster files.}

\item{scale_max}{Suitability scale maximum value (common values are 1.0, 100.0, and 255.0).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a weighted sum on multiple input rasters after converting each image to a common scale. The tool performs a multi-criteria evaluation (MCE).
}
