% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{lidar_point_density}
\alias{lidar_point_density}
\title{Lidar point density}
\usage{
lidar_point_density(input, output = NULL, returns = "all",
  resolution = 1, radius = 2.5, exclude_cls = NULL, minz = NULL,
  maxz = NULL, verbose_mode = FALSE)
}
\arguments{
\item{input}{Input LiDAR file (including extension).}

\item{output}{Output raster file (including extension).}

\item{returns}{Point return types to include; options are 'all' (default), 'last', 'first'.}

\item{resolution}{Output raster's grid resolution.}

\item{radius}{Search Radius.}

\item{exclude_cls}{Optional exclude classes from interpolation; Valid class values range from 0 to 18, based on LAS specifications. Example, --exclude_cls='3,4,5,6,7,18'.}

\item{minz}{Optional minimum elevation for inclusion in interpolation.}

\item{maxz}{Optional maximum elevation for inclusion in interpolation.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates the spatial pattern of point density for a LiDAR data set. When the input/output parameters are not specified, the tool grids all LAS files contained within the working directory.
}
