% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-data.R
\name{read_data}
\alias{read_data}
\title{Read data from metabolic cart}
\usage{
read_data(
  path,
  metabolic_cart = c("cosmed", "cortex", "nspire", "parvo", "geratherm", "cardiocoach"),
  time_column = "t",
  work_rate_column = NULL
)
}
\arguments{
\item{path}{Path to read the file from.}

\item{metabolic_cart}{Metabolic cart that was used for data collection. Currently, 'cosmed', 'cortex', 'nspire', 'parvo', 'geratherm', and 'cardiocoach' are supported.}

\item{time_column}{The name (quoted) of the column containing the time. Depending on the language of your system, this column might not be "t". Therefore, you may specify it here.  Default to "t".}

\item{work_rate_column}{Default is \code{NULL}. In case your work rate column is coerced as a character column
you can define here the name of this column in your data file. This happens because at the very beginning of the test
the system may input a character like "-" to indicate no work rate. Therefore this is not going to get recognized as a numeric column.
If your work rate column is called \code{WR}, for example, just pass \code{"WR"} to this argument.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
It reads the raw data exported from the metabolic cart.
}
