% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wkt_coords}
\alias{wkt_coords}
\title{Extract Latitude and Longitude from WKT polygons}
\usage{
wkt_coords(wkt)
}
\arguments{
\item{wkt}{a character vector of WKT objects}
}
\value{
a data.frame of four columns; \code{object} (containing which object
the row refers to), \code{ring} containing which layer of the object the row
refers to, \code{lng} and \code{lat}.
}
\description{
\code{wkt_coords} extracts lat/long values from WKT polygons,
specifically the outer shell of those polygons (working on the assumption
that said outer edge is what you want).

Because it assumes \strong{coordinates}, it also assumes a sphere - say, the
earth - and uses spherical coordinate values.
}
\examples{
wkt_coords("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")
}
\seealso{
\code{\link[=wkt_bounding]{wkt_bounding()}} to extract a bounding box, and \code{\link[=wkt_centroid]{wkt_centroid()}}
to extract the centroid.
}
