% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\encoding{UTF-8}
\name{plot_mod_mix}
\alias{plot_mod_mix}
\title{Adding Estimated Population Lines of a Separated Mixture Model to a
Probability Plot}
\usage{
plot_mod_mix(p_obj, x, event, mix_output, distribution = c("weibull",
  "lognormal", "loglogistic"), title_trace = "Fit")
}
\arguments{
\item{p_obj}{a plotly object provided by function \code{\link{plot_prob_mix}}.}

\item{x}{a numeric vector containing the x-coordinates of the regression line.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{mix_output}{a list provided by \code{\link{mixmod_regression}} or
\code{\link{mixmod_em}}, which consists of elements necessary to visualize
the regression lines.}

\item{distribution}{supposed distribution of the random variable. For output
provided by \code{mixmod_em} distribution must be \code{"weibull"}. Can be
\code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"} for output provided
\code{mixmod_regression}. Other distributions have not been implemented yet.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the probability plot with
  plotting positions and estimated regression line(s).
}
\description{
This function adds one or multiple estimated regression lines to an existing
probability plot (\code{\link{plot_prob_mix}}). Depending on the output of the
function \code{\link{mixmod_regression}} or \code{\link{mixmod_em}} one or
multiple lines are plotted.
}
\details{
The name of the legend entry is a combination of the \code{title_trace} and the
number of determined subgroups. If \code{title_trace = "Line"} and the data
could be splitted in two groups, the legend entries would be "Line 1" and "Line 2".
}
\examples{
# Data is taken from given reference:
hours <- c(2, 28, 67, 119, 179, 236, 282, 317, 348, 387, 3, 31, 69, 135,
          191, 241, 284, 318, 348, 392, 5, 31, 76, 144, 203, 257, 286,
          320, 350, 412, 8, 52, 78, 157, 211, 261, 298, 327, 360, 446,
          13, 53, 104, 160, 221, 264, 303, 328, 369, 21, 64, 113, 168,
          226, 278, 314, 328, 377)
state <- c(1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1,
          1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
          1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
          0, 1, 1, 1, 1, 1, 1)
id <- 1:length(hours)

# Example 1 - Using result of mixmod_em in mix_output:
mix_mod_em <- mixmod_em(x = hours, event = state, distribution = "weibull",
                        conf_level = 0.95, k = 2, method = "EM", n_iter = 150)

plot_weibull_em <- plot_prob_mix(x = hours,
                                 event = state,
                                 id = id,
                                 distribution = "weibull",
                                 mix_output = mix_mod_em,
                                 title_main = "Weibull Mixture EM",
                                 title_x = "Time in Hours",
                                 title_y = "Probability of Failure",
                                 title_trace = "Subgroup")

plot_weibull_emlines <- plot_mod_mix(p_obj = plot_weibull_em,
                                   x = hours,
                                   event = state,
                                   mix_output = mix_mod_em,
                                   distribution = "weibull",
                                   title_trace = "Fitted Line")

# Example 2 - Using result of mixmod_regression in mix_output:
john <- johnson_method(x = hours, event = state)
mix_mod_reg <- mixmod_regression(x = john$characteristic,
                                 y = john$prob,
                                 event = john$status,
                                 distribution = "weibull")

plot_weibull_reg <- plot_prob_mix(x = hours,
                                  event = state,
                                  id = id,
                                  distribution = "weibull",
                                  mix_output = mix_mod_reg,
                                  title_main = "Weibull Mixture Regression",
                                  title_x = "Time in Hours",
                                  title_y = "Probability of Failure",
                                  title_trace = "Subgroup")

plot_weibull_reglines <- plot_mod_mix(p_obj = plot_weibull_reg,
                                   x = hours,
                                   event = state,
                                   mix_output = mix_mod_reg,
                                   distribution = "weibull",
                                   title_trace = "Fitted Line")
}
\references{
Doganaksoy, N.; Hahn, G.; Meeker, W. Q., Reliability Analysis by
  Failure Mode, Quality Progress, 35(6), 47-52, 2002
}
