% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_mod_mix}
\alias{plot_mod_mix}
\title{Adding Estimated Population Lines of a Separated Mixture Model to a
Probability Plot}
\usage{
plot_mod_mix(p_obj, x, y = NULL, reg_output, distribution = c("weibull",
  "lognormal", "loglogistic"), title_trace = "Fit")
}
\arguments{
\item{p_obj}{a plotly object provided by function \code{\link{plot_prob_mix}}.}

\item{x}{a numeric vector containing the x-coordinates of the regression line.}

\item{y}{a numeric vector containing the y-coordinates of the regression line.
The default value of y is \code{NULL}. If \code{y} is set \code{NULL} the
y-coordinates with respect to \code{x} are calculated by function
\code{predict_prob} using estimated coefficients in \code{reg_output}.}

\item{reg_output}{a list provided by \code{\link{mixmod_regression}} which
consists of elements necessary to visualize the regression lines.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the probability plot with
  plotting positions and estimated regression line(s).
}
\description{
This function adds one or multiple estimated regression lines to an existing
probability plot (\code{\link{plot_prob_mix}}). Depending on the output of the
function \code{\link{mixmod_regression}} one or multiple lines are plotted.
}
\examples{
hours <- c(2, 28, 67, 119, 179, 236, 282, 317, 348, 387, 3, 31, 69, 135,
          191, 241, 284, 318, 348, 392, 5, 31, 76, 144, 203, 257, 286,
          320, 350, 412, 8, 52, 78, 157, 211, 261, 298, 327, 360, 446,
          13, 53, 104, 160, 221, 264, 303, 328, 369, 21, 64, 113, 168,
          226, 278, 314, 328, 377)
state <- c(1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1,
          1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
          1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
          0, 1, 1, 1, 1, 1, 1)
john <- johnson_method(x = hours, event = state)

mix_mod <- mixmod_regression(x = john$characteristic,
                             y = john$prob,
                             event = john$status,
                             distribution = "weibull")

plot_weibull_mix <- plot_prob_mix(x = john$characteristic,
                                  y = john$prob,
                                  event = john$status,
                                  id = john$id,
                                  distribution = "weibull",
                                  reg_output = mix_mod,
                                  title_main = "Mixture Weibull Analysis",
                                  title_x = "Time in Hours",
                                  title_y = "Probability of Failure",
                                  title_trace = "classification")
plot_weibull_reg_mix <- plot_mod_mix(p_obj = plot_weibull_mix, x = hours,
                             reg_output = mix_mod,
                             distribution = "weibull",
                             title_trace = "model")
}
