% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_mod}
\alias{plot_mod}
\title{Adding an Estimated Population Line to a Probability Plot}
\usage{
plot_mod(p_obj, x, y = NULL, loc_sc_params, distribution = c("weibull",
  "lognormal", "loglogistic"), title_trace = "Fit")
}
\arguments{
\item{p_obj}{a plotly object provided by function \code{\link{plot_prob}}.}

\item{x}{a numeric vector containing the x-coordinates of the regression line.}

\item{y}{a numeric vector containing the y-coordinates of the regression line.
The default value of y is \code{NULL}. If \code{y} is set \code{NULL} the
y-coordinates with respect to \code{x} are calculated by function
\code{predict_prob} using estimated coefficients in \code{loc_sc_params}. If
confidence interval(s) should be added to the plot y should not be set to
\code{NULL}. For more information see \strong{Details} in \code{\link{plot_conf}}.}

\item{loc_sc_params}{a (named) numeric vector of estimated location and scale
parameters for a specified distribution. The order of elements is
important. First entry needs to be the location parameter \eqn{\mu} and the
second element needs to be the scale parameter \eqn{\sigma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the probability plot with
  plotting positions and the estimated regression line.
}
\description{
This function adds a regression line to an existing probability plot using a
model estimated by \code{\link{rank_regression}} or \code{\link{ml_estimation}}.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
id <- LETTERS[1:length(obs)]

df_john <- johnson_method(x = obs, event = state, id = id)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .90)

plot_weibull <- plot_prob(x = df_john$characteristic,
                          y = df_john$prob,
                          event = df_john$status,
                          id = df_john$id,
                          distribution = "weibull",
                          title_main = "Weibull Analysis",
                          title_x = "Mileage in miles",
                          title_y = "Probability of Failure in \%",
                          title_trace = "Failed Items")

plot_reg_weibull <- plot_mod(p_obj = plot_weibull, x = obs,
                             loc_sc_params = mrr$loc_sc_coefficients,
                             distribution = "weibull",
                             title_trace = "Estimated Weibull CDF")
}
