% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.r
\name{cookie}
\alias{cookie}
\title{Assemble an HTTP cookie.}
\usage{
cookie(
  ...,
  max_age = NULL,
  domain = NULL,
  path = NULL,
  same_site = "Lax",
  secure = FALSE,
  http_only = FALSE,
  partitioned = FALSE,
  name = ...names(),
  value = ..1
)
}
\arguments{
\item{...}{A single key-value pair.}

\item{max_age}{The number of seconds until expiration. Omit to create a
session cookie. \code{Inf} is mapped to 34560000L (400 days).}

\item{domain}{Send with requests to this host.}

\item{path}{Send with requests to this path.}

\item{same_site}{\code{'Strict'}, \code{'Lax'}, or \code{'None'}.
\code{secure} required for \code{'None'}.}

\item{secure}{Only send over HTTPS.}

\item{http_only}{Disallow javascript access.}

\item{partitioned}{Use partitioned storage. \code{secure} required.}

\item{name}{Explicitly set the name (key) in the key-value pair.}

\item{value}{Explicitly set the value in the key-value pair.}
}
\value{
A 'header' object that can be passed to \code{response()}.
}
\description{
See https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie for
a more in-depth description of each parameter's purpose.
}
\examples{

    library(webqueue)
    
    cookie(xyz = 123, max_age = 3600, http_only = TRUE)
    
    token <- 'randomstring123'
    cookie(token)
    
    response(cookie(token = 'randomstring123'))
    
}
