% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ggplot.R
\name{as_ggplot}
\alias{as_ggplot}
\title{Convert stimuli to a ggplot}
\usage{
as_ggplot(stimuli, ...)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{...}{Additional arguments to pass to \code{\link[=plot_stim]{plot_stim()}} if stimuli contains more than 1 image}
}
\value{
a ggplot object
}
\description{
Convert a stimulus or list of stimuli into a ggplot, which can be further used with ggplot functions.
}
\examples{
stimuli <- demo_stim()
gg <- as_ggplot(stimuli)

# add to ggplot object; coordinates are pixels
# (images are 500x500 each, plus 10px padding)
gg + 
  ggplot2::geom_vline(xintercept = 0, color = "red") +
  ggplot2::geom_vline(xintercept = 1030, color = "blue") +
  ggplot2::geom_hline(yintercept = 0, color = "green") +
  ggplot2::geom_hline(yintercept = 520, color = "purple") +
  ggplot2::annotate("point", x = 515, y = 260, size = 10) +
  ggplot2::labs(
    title = "This is a ggplot!",
    caption = "Made with webmorphR"
  )
}
\seealso{
Visualisation functions
\code{\link{draw_tem}()},
\code{\link{gglabel}()},
\code{\link{label}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()},
\code{\link{plot_stim}()}
}
\concept{viz}
