% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictFundamental.R
\name{predictFundamental}
\alias{predictFundamental}
\title{Predicts species fundamental niche}
\usage{
predictFundamental(
  tSDM,
  Xnew = NULL,
  pred_samples = NULL,
  verbose = FALSE,
  fullPost = TRUE
)
}
\arguments{
\item{tSDM}{A trophicSDMfit object obtained with trophicSDM()}

\item{Xnew}{a matrix specifying the environmental covariates for the predictions to be made. If NULL (default), predictions are done on the training dataset (e.g. by setting Xnew = tSDM$data$X).}

\item{pred_samples}{Number of samples to draw from species posterior predictive distribution when method = "stan_glm". If NULL, set by the default to the number of iterations/10.}

\item{verbose}{Whether to print advances of the algorithm.}

\item{fullPost}{Optional parameter for stan_glm only. Whether to give back the full posterior predictive distribution (default, fullPost = TRUE) or just the posterior mean, and 2.5\% and 97.5\% quantiles.}
}
\value{
A list containing for each species the predicted value at each sites. If method = "stan_glm", then each element of the list is a sites x pred_samples matrix containing the posterior predictive distribution of the species at each sites.
}
\description{
Computes predicted values of the fundamental niches of species from the fitted trophicSDMfit model at environmental conditions specified by \code{Xnew}. Predictions are obtained by setting preys to present when mode = "prey" or setting predators to absent when mode = "predator".
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
# Obtain 100 draws from the posterior predictive distribution of species fundamental niche
# (pred_samples = 50)
# Since we don't specify Xnew, the function sets Xnew = X by default
Ypred = predictFundamental(m, fullPost = TRUE, pred_samples = 50)
# We can ask the function to only give back posterior mean and 95\% credible intervals with
# fullPost = FALSE
\donttest{
Ypred = predictFundamental(m, fullPost = FALSE, pred_samples = 50)
}
#' We can now evaluate species probabilities of presence for the enviromental
# conditions c(0.5, 0.5)
predictFundamental(m, Xnew = data.frame(X_1 = 0.5, X_2 = 0.5), pred_samples = 50)

# If we fit the model using in a frequentist  way (e.g. glm)
m = trophicSDM(Y, X, G, env.formula, 
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "glm")
# We are obliged to set pred_samples = 1 
# (this is done by default if pred_samples is not provided)
# In the frequentist case, fullPost is useless.
Ypred = predictFundamental(m, pred_samples = 1)
}
\author{
Giovanni Poggiato and Jérémy Andréoletti
}
