% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_key.R
\name{get_key}
\alias{get_key}
\title{Get or Set Up API Keys}
\usage{
get_key(service = c("DPIRD", "SILO"))
}
\arguments{
\item{service}{(character) The \acronym{API} host, either \dQuote{DPIRD} or
\dQuote{SILO}.}
}
\value{
A string value with either a \acronym{DPIRD} Weather 2.0 API or
\acronym{SILO} API key value.
}
\description{
Checks first to get key from your .Rprofile or .Renviron (or similar) file.
If it's not found, then it suggests setting it up.  Can be used to check
that your key that R is using is the key that you wish to be using or for
guidance in setting up the keys.
}
\details{
The suggestion is to use your .Renviron to set up the API keys. However, if
you regularly interact with the APIs outside of R using some other language
you may wish to set these up in your .bashrc, .zshrc, or config.fish for
cross-language use.
}
\examples{
\dontrun{
  get_key(service = "DPIRD")
  get_key(service = "SILO")
}

}
