% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregateSpectra.R
\name{AggregateSpectra}
\alias{AggregateSpectra}
\title{Aggregate data based on grouping variables and a user-provided
  function}
\usage{
AggregateSpectra(df, grouping.colnames, reference.value.colname,
  agg.function)
}
\arguments{
\item{df}{\code{data.frame} object containing one or multiple columns of
grouping variables (must be consistent within each group), column of
reference values (optional), and columns of spectra. Spectral column names
must start with "X".}

\item{grouping.colnames}{Names of columns to be used as grouping variables.
Minimum 2 variables required. Default is c("trial", "plot").}

\item{reference.value.colname}{Name of reference column to be aggregated
along with spectra. Default is "reference"}

\item{agg.function}{Name of function (string format) to be used for sample
aggregation. Must be either "mean" or "median". Default is "mean".}
}
\value{
\code{data.frame} object \code{df} aggregated based on grouping
  column by \code{agg.function}
}
\description{
Use grouping variables to collapse spectral \code{data.frame} by
  mean or median. Recommended for use after \code{\link{FilterSpectra}}
}
\examples{
library(magrittr)
aggregated.test <- ikeogu.2017 \%>\%
  dplyr::select(-TCC) \%>\%
  na.omit() \%>\%
  AggregateSpectra(grouping.colnames = c("study.name"),
                   reference.value.colname = "DMC.oven",
                   agg.function = "mean")
aggregated.test[1:5, 1:5]
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
