% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawtocomposite.R
\name{rawtocomposite}
\alias{rawtocomposite}
\title{rawtocomposite}
\usage{
rawtocomposite(voxr, inten_index = 2)
}
\arguments{
\item{voxr}{the object from the waveformvoxel.}

\item{inten_index}{the value (1,2,3,4,...) to represnt the intensity of composite waveforms.It is a integer from 1 to 4 and default is 2.
1: the number of intensity of the voxel (generally is not useful); 2: the maximum intensity of the waveform voxel; 3: the mean intensity of the waveform voxel;
4: the total intensity of voxel(the last one is also not prefered in most cases)}
}
\value{
A dataframe with first three columns including geolocation xyz of the first Non-NA intensity (Highest position) and intensities along the height bins, other non-NA values are intensities for the rest columns.
  \item{x}{The x position of the first Non-NA intensity or highest intensity position in one waveform}
  \item{y}{The y position of the first Non-NA intensity or highest intensity position in one waveform}
  \item{z}{The z position of the first Non-NA intensity or highest intensity position in one waveform}
  \item{intensity 1}{The intnesity of first height bin}
  \item{intensity 2}{The intensity of second height bin}
  \item{...}{Intensities along the height bin}
}
\description{
The function allows you to convert point cloud after waveformvoxel or raw waveforms into composite waveforms (with vertical distribution of intensity)
by reducing the effect of off-naid angle of emitted laser.
The conversion is based on the waveform voxellization product. Four kinds of values you can chose to represent the intensity of composite waveform:
the number of intensity (generally is not useful), mean intensity, maximum intensity and total intensity (the last one is also not prefered in most of cases).
}
\examples{

data(return)  ###import raw return waveforms
data(geo)  ###import corresponding reference geolocation
colnames(geo)[2:9]<-c("x","y","z","dx","dy","dz","or","fr")
### you should know which columns corresponding to above column names before
### run the hyperpointcloud when you used your own new datasets.

hpr<-hyperpointcloud(waveform=return,geo=geo)

##beofre run waveformvoxel, we need to create hyperpointcloud first
##this exampel we just used 100000 points to reduce processing time

voxr<-waveformvoxel(hpc=hpr,res=c(1,1,0.3))
rtc<-rawtocomposite(voxr)
}
