% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall.R
\name{waterfall}
\alias{waterfall}
\title{Create waterfall charts}
\usage{
waterfall(.data = NULL, values, labels, rect_text_labels = values,
  rect_text_size = 1, rect_text_labels_anchor = "centre",
  put_rect_text_outside_when_value_below = 0.05 * (max(cumsum(values)) -
  min(cumsum(values))), calc_total = FALSE, total_axis_text = "Total",
  total_rect_text = sum(values), total_rect_color = "black",
  total_rect_text_color = "white", fill_colours = NULL,
  fill_by_sign = TRUE, rect_width = 0.7, rect_border = "black",
  draw_lines = TRUE, lines_anchors = c("right", "left"),
  linetype = "dashed", draw_axis.x = "behind", theme_text_family = "",
  scale_y_to_waterfall = TRUE, print_plot = FALSE,
  ggplot_object_name = "mywaterfall")
}
\arguments{
\item{.data}{a \code{data.frame} containing two columns, one with the values, the other with the labels}

\item{values}{a numeric vector making up the heights of the rectangles in the waterfall}

\item{labels}{the labels corresponding to each vector, marked on the x-axis}

\item{rect_text_labels}{(character) a character vector of the same length as values that are placed on the rectangles}

\item{rect_text_size}{size of the text in the rectangles}

\item{rect_text_labels_anchor}{(character) How should \code{rect_text_labels} be positioned? In future releases, we might have support for north or south anchors, or for directed positioning (negative down, positive up) etc. For now, only centre is supported.}

\item{put_rect_text_outside_when_value_below}{(numeric) the text labels accompanying a rectangle of this height will be placed outside the box: below if it's negative; above if it's positive.}

\item{calc_total}{(logical, default: \code{FALSE}) should the final pool of the waterfall be calculated (and placed on the chart)}

\item{total_axis_text}{(character) the text appearing on the axis underneath the total rectangle}

\item{total_rect_text}{(character) the text in the middle of the rectangle of the total rectangle}

\item{total_rect_color}{the color of the final rectangle}

\item{total_rect_text_color}{the color of the final rectangle's label text}

\item{fill_colours}{Colours to be used to fill the rectangles, in order. Disregarded if \code{fill_by_sign} is \code{TRUE} (the default).}

\item{fill_by_sign}{(logical, default: \code{TRUE}) should positive and negative values each have the same colour?}

\item{rect_width}{(numeric) the width of the rectangle, relative to the space between each label factor}

\item{rect_border}{the border around each rectangle. Choose \code{NA} if no border is desired.}

\item{draw_lines}{(logical, default: \code{TRUE}) should lines be drawn between successive rectangles}

\item{lines_anchors}{a character vector of length two specifying the horizontal placement of the drawn lines relative to the preceding and successive rectangles, respectively}

\item{linetype}{the linetype for the draw_lines}

\item{draw_axis.x}{(character) one of "none", "behind", "front" whether to draw an x.axis line and whether to draw it behind or in front of the rectangles, default is behind}

\item{theme_text_family}{(character) Passed to the \code{text} argument in \code{ggplot2::theme}.}

\item{scale_y_to_waterfall}{(logical, default: \code{TRUE}) Should the default range of the y-axis be from the bottom of the lowest pool to the top of the highest? If \code{FALSE}, which was the only option before version 0.1.2, the range of the plot is more balanced around the y-axis.}

\item{print_plot}{(logical) Whether or not the plot should be printed. By default, \code{TRUE}, which means it cannot be assigned.}

\item{ggplot_object_name}{(character) A quoted valid object name to which ggplot layers may be added after the function has run. Ignored if \code{print} is \code{FALSE}.}
}
\description{
Create waterfall charts
}
\examples{
waterfall(values = round(rnorm(5), 1), labels = letters[1:5], calc_total = TRUE)
waterfall(.data = data.frame(category = letters[1:5],
                             value = c(100, -20, 10, 20, 110)), 
          fill_colours = colorRampPalette(c("#1b7cd6", "#d5e6f2"))(5),
          fill_by_sign = FALSE)
}
\author{
Based on \code{grattan_waterfall} from the 'grattanCharts' package (\url{https://github.com/HughParsonage/grattanCharts}).
}
