% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_netRadiation.G.R
\name{SWtrasmisivity}
\alias{SWtrasmisivity}
\title{Calculates short wave transmisivity}
\usage{
SWtrasmisivity(Kt = 1, ea, dem, incidence.hor)
}
\arguments{
\item{Kt}{unitless turbidity coefficient 0<Kt<=1.0, where Kt=1.0 for clean air and Kt=0.5 for extremely turbid, dusty, or polluted air}

\item{ea}{near-surface vapor pressure (kPa)}

\item{dem}{digital elevation model}

\item{incidence.hor}{solar incidence angle, considering plain surface}
}
\description{
Short wave transmisivity is estimated for broad-band considering an extended equation developed by Allen (1996), based from Majumdar et al.(1972), using coefficients developed by ASCE-EWRI (2005).
}
\author{
Guillermo Federico Olmedo

Fonseca-Luengo, David
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007 \cr

Majumdar, N.; Mathur, B. & Kaushik, S. Prediction of direct solar radiation for low atmospheric turbidity Solar Energy, Elsevier, 1972, 13, 383-394 \cr

ASCE-EWRI The ASCE Standardized Reference Evapotranspiration Equation Report of the ASCE-EWRI Task Committee on Standardization of Reference Evapotranspiration, 2005 \cr
}

