% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfts.R
\name{dfts}
\alias{dfts}
\title{Extract the dominant frequency values as a time series}
\usage{
dfts(X, wl = 512, wl.freq = 512, length.out = 20, wn = "hanning", ovlp = 70,
bp = c(0, 22), threshold = 15, threshold.time = NULL, threshold.freq = NULL, 
img = TRUE, parallel = 1, path = NULL, img.suffix = "dfts", pb = TRUE,
clip.edges = FALSE, leglab = "dfts", frange.detec = FALSE, fsmooth = 0.1,
 raw.contour = FALSE, track.harm = FALSE, adjust.wl = FALSE, ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{wl.freq}{A numeric vector of length 1 specifying the window length of the spectrogram
for measurements on the frecuency spectrum. Default is 512. Higher values would provide 
more accurate measurements.}

\item{length.out}{A numeric vector of length 1 giving the number of measurements of dominant 
frequency desired (the length of the time series).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{threshold}{amplitude threshold (\%) for dominant frequency detection. Default is 15. Note that amplitude 
threshold for time and frequency domains can be defined independently. See "threshold.time" and "threshold.freq" 
arguments.}

\item{threshold.time}{amplitude threshold (\%) for the time domain. Use for dominant frequency detection. If \code{NULL} (default) then the 'threshold' value is used.}

\item{threshold.freq}{amplitude threshold (\%) for the frequency domain. Use for frequency range detection from the spectrum (see 'frange.detec'). If \code{NULL} (default) then the
'threshold' value is used.}

\item{img}{Logical argument. If \code{FALSE}, image files are not produced. Default is \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located.}

\item{img.suffix}{A character vector of length 1 with a sufix (label) to add at the end of the names of 
image files.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{clip.edges}{Logical argument to control whether edges (start or end of signal) in
which amplitude values above the threshold were not detected will be removed. If 
\code{TRUE} this edges will be excluded and signal contour will be calculated on the
remainging values. Default is \code{FALSE}.}

\item{leglab}{A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{frange.detec}{Logical. Controls whether frequency range of signal is automatically 
detected  using the \code{\link{frange.detec}} function. If so, the range is used as the 
bandpass filter (overwriting 'bp' argument). Default is \code{FALSE}.}

\item{fsmooth}{A numeric vector of length 1 to smooth the frequency spectrum with a mean
sliding window (in kHz) used for frequency range detection (when \code{frange.detec = TRUE}). This help to average amplitude "hills" to minimize the effect of
amplitude modulation. Default is 0.1.}

\item{raw.contour}{Logical. If \code{TRUE} then a list with the original contours 
(i.e. without interpolating values to make all contours of equal length) is returned.}

\item{track.harm}{Logical. If true warbleR's \code{\link{track_harm}} function is 
used to track frequency contours. Otherwise seewave's \code{\link[seewave]{dfreq}} is used by default.}

\item{adjust.wl}{Logical. If \code{TRUE} the 'wl' is reset to be equal at the 
number of samples in a selections if the samples are less than 'wl'. Default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to \code{\link{trackfreqs}}.}
}
\value{
If \code{raw.contour = TRUE} (default) a data frame with the dominant frequency values measured across the signals.  Otherwise, a list with the raw frequency detections (i.e. without interpolating values to make all contours of equal length) is returned. If img is 
\code{TRUE} it also produces image files with the spectrograms of the signals listed in the 
input data frame showing the location of the dominant frequencies 
(see \code{\link{trackfreqs}} description for more details).
}
\description{
\code{dfts} extracts the dominant frequency values as a time series.
of signals selected by \code{\link{manualoc}} or \code{\link{autodetec}}.
}
\details{
This function extracts the dominant frequency values as a time series. 
The function uses the \code{\link[stats]{approx}} function to interpolate values between dominant frequency 
measures. If there are no frequencies above the amplitude theshold at the begining or end 
 of the signals then NAs will be generated. On the other hand, if there are no frequencies 
 above the amplitude theshold in between signal segments in which amplitude was 
 detected then the values of this adjacent segments will be interpolated 
 to fill out the missing values (e.g. no NAs in between detected amplitude segments).
}
\examples{
{
# set the temp directory
# setwd(tempdir())

#load data
data(list = c("Phae.long1", "Phae.long2","selec.table"))
writeWave(Phae.long2, "Phae.long2.wav") #save sound files 
writeWave(Phae.long1, "Phae.long1.wav")

# run function 
dfts(X = selec.table, length.out = 30, flim = c(1, 12), bp = c(2, 9), wl = 300)

}
}
\seealso{
\code{\link{sig2noise}}, \code{\link{trackfreqs}}, \code{\link{sp.en.ts}}, \code{\link{ffts}}, \code{\link{ffDTW}}, \code{\link{dfDTW}}

Other spectrogram creators: \code{\link{color.spectro}},
  \code{\link{dfDTW}}, \code{\link{ffDTW}},
  \code{\link{ffts}}, \code{\link{snrspecs}},
  \code{\link{sp.en.ts}}, \code{\link{specreator}},
  \code{\link{trackfreqs}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
