% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rplots.h.R
\name{rplots}
\alias{rplots}
\title{Box & Violin Plots}
\usage{
rplots(data, vars, splitBy = NULL, violin = TRUE, boxplot = FALSE,
  dot = TRUE, dotType = "stack")
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables in \code{data} of
interest}

\item{splitBy}{a string naming the variable in \code{data} to split the
data by}

\item{violin}{\code{TRUE} (default) or \code{FALSE}, provide violin plots}

\item{boxplot}{\code{TRUE} or \code{FALSE} (default), provide box plots}

\item{dot}{\code{TRUE} (default) or \code{FALSE}, plot each measurement as
a dot}

\item{dotType}{\code{'jitter'} or \code{'stack'} (default); whether data
dots are jittered or stacked}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
}
}
\description{
Box & Violin Plots
}
\examples{
data('eurosoccer', package='WRS2')

# violin plots

walrus::rplots(
    data = eurosoccer,
    vars = "GoalsGame",
    splitBy = "League")


# box plots

walrus::rplots(
    data = eurosoccer,
    vars = "GoalsGame",
    splitBy = "League",
    violin = FALSE,
    boxplot = TRUE,
    dot = FALSE)

}
