// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_walker_glm_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 230, column 2 to column 29)",
                                                      " (in 'string', line 231, column 2 to column 33)",
                                                      " (in 'string', line 232, column 2 to column 33)",
                                                      " (in 'string', line 235, column 2 to column 42)",
                                                      " (in 'string', line 236, column 2 to column 18)",
                                                      " (in 'string', line 237, column 2 to column 15)",
                                                      " (in 'string', line 238, column 2 to column 22)",
                                                      " (in 'string', line 243, column 4 to column 31)",
                                                      " (in 'string', line 242, column 9 to line 244, column 3)",
                                                      " (in 'string', line 241, column 4 to column 36)",
                                                      " (in 'string', line 240, column 19 to line 242, column 3)",
                                                      " (in 'string', line 240, column 2 to line 244, column 3)",
                                                      " (in 'string', line 245, column 2 to column 17)",
                                                      " (in 'string', line 249, column 6 to column 52)",
                                                      " (in 'string', line 248, column 22 to line 250, column 5)",
                                                      " (in 'string', line 248, column 4 to line 250, column 5)",
                                                      " (in 'string', line 252, column 6 to column 56)",
                                                      " (in 'string', line 251, column 22 to line 253, column 5)",
                                                      " (in 'string', line 251, column 4 to line 253, column 5)",
                                                      " (in 'string', line 247, column 17 to line 254, column 3)",
                                                      " (in 'string', line 247, column 2 to line 254, column 3)",
                                                      " (in 'string', line 256, column 2 to line 257, column 55)",
                                                      " (in 'string', line 271, column 2 to column 38)",
                                                      " (in 'string', line 272, column 2 to column 37)",
                                                      " (in 'string', line 273, column 2 to column 15)",
                                                      " (in 'string', line 274, column 2 to column 33)",
                                                      " (in 'string', line 275, column 2 to column 33)",
                                                      " (in 'string', line 277, column 2 to column 48)",
                                                      " (in 'string', line 281, column 11 to column 12)",
                                                      " (in 'string', line 281, column 4 to column 22)",
                                                      " (in 'string', line 282, column 11 to column 12)",
                                                      " (in 'string', line 282, column 14 to column 15)",
                                                      " (in 'string', line 282, column 4 to column 24)",
                                                      " (in 'string', line 283, column 11 to column 16)",
                                                      " (in 'string', line 283, column 18 to column 19)",
                                                      " (in 'string', line 283, column 4 to column 26)",
                                                      " (in 'string', line 284, column 20 to column 21)",
                                                      " (in 'string', line 284, column 23 to column 24)",
                                                      " (in 'string', line 284, column 26 to column 27)",
                                                      " (in 'string', line 284, column 4 to column 29)",
                                                      " (in 'string', line 285, column 18 to column 23)",
                                                      " (in 'string', line 285, column 25 to column 26)",
                                                      " (in 'string', line 285, column 28 to column 29)",
                                                      " (in 'string', line 285, column 4 to column 31)",
                                                      " (in 'string', line 286, column 11 to column 12)",
                                                      " (in 'string', line 286, column 4 to column 37)",
                                                      " (in 'string', line 296, column 8 to column 62)",
                                                      " (in 'string', line 295, column 24 to line 297, column 7)",
                                                      " (in 'string', line 295, column 6 to line 297, column 7)",
                                                      " (in 'string', line 299, column 8 to column 70)",
                                                      " (in 'string', line 300, column 8 to column 48)",
                                                      " (in 'string', line 298, column 24 to line 301, column 7)",
                                                      " (in 'string', line 298, column 6 to line 301, column 7)",
                                                      " (in 'string', line 305, column 10 to column 86)",
                                                      " (in 'string', line 304, column 26 to line 306, column 9)",
                                                      " (in 'string', line 304, column 8 to line 306, column 9)",
                                                      " (in 'string', line 308, column 10 to column 69)",
                                                      " (in 'string', line 309, column 10 to column 82)",
                                                      " (in 'string', line 307, column 26 to line 310, column 9)",
                                                      " (in 'string', line 307, column 8 to line 310, column 9)",
                                                      " (in 'string', line 303, column 27 to line 311, column 7)",
                                                      " (in 'string', line 303, column 6 to line 311, column 7)",
                                                      " (in 'string', line 314, column 8 to column 85)",
                                                      " (in 'string', line 313, column 20 to line 315, column 7)",
                                                      " (in 'string', line 313, column 6 to line 315, column 7)",
                                                      " (in 'string', line 318, column 15 to column 16)",
                                                      " (in 'string', line 318, column 18 to column 19)",
                                                      " (in 'string', line 318, column 8 to line 319, column 29)",
                                                      " (in 'string', line 320, column 8 to column 35)",
                                                      " (in 'string', line 321, column 22 to column 53)",
                                                      " (in 'string', line 321, column 8 to column 53)",
                                                      " (in 'string', line 317, column 6 to line 322, column 7)",
                                                      " (in 'string', line 324, column 6 to column 50)",
                                                      " (in 'string', line 325, column 20 to column 64)",
                                                      " (in 'string', line 325, column 6 to column 64)",
                                                      " (in 'string', line 327, column 6 to column 37)",
                                                      " (in 'string', line 336, column 10 to column 78)",
                                                      " (in 'string', line 337, column 10 to line 338, column 45)",
                                                      " (in 'string', line 335, column 22 to line 339, column 9)",
                                                      " (in 'string', line 335, column 8 to line 339, column 9)",
                                                      " (in 'string', line 334, column 13 to line 340, column 7)",
                                                      " (in 'string', line 330, column 10 to column 78)",
                                                      " (in 'string', line 331, column 10 to line 332, column 45)",
                                                      " (in 'string', line 329, column 22 to line 333, column 9)",
                                                      " (in 'string', line 329, column 8 to line 333, column 9)",
                                                      " (in 'string', line 328, column 29 to line 334, column 7)",
                                                      " (in 'string', line 328, column 6 to line 340, column 7)",
                                                      " (in 'string', line 293, column 18 to line 341, column 5)",
                                                      " (in 'string', line 293, column 4 to line 341, column 5)",
                                                      " (in 'string', line 350, column 6 to column 16)",
                                                      " (in 'string', line 351, column 13 to column 14)",
                                                      " (in 'string', line 351, column 6 to column 30)",
                                                      " (in 'string', line 352, column 6 to column 27)",
                                                      " (in 'string', line 353, column 6 to column 48)",
                                                      " (in 'string', line 354, column 6 to column 49)",
                                                      " (in 'string', line 355, column 21 to column 57)",
                                                      " (in 'string', line 355, column 6 to column 57)",
                                                      " (in 'string', line 366, column 10 to column 77)",
                                                      " (in 'string', line 367, column 10 to column 39)",
                                                      " (in 'string', line 368, column 10 to column 50)",
                                                      " (in 'string', line 365, column 22 to line 369, column 9)",
                                                      " (in 'string', line 365, column 8 to line 369, column 9)",
                                                      " (in 'string', line 364, column 13 to line 370, column 7)",
                                                      " (in 'string', line 361, column 10 to column 84)",
                                                      " (in 'string', line 362, column 10 to column 43)",
                                                      " (in 'string', line 360, column 22 to line 363, column 9)",
                                                      " (in 'string', line 360, column 8 to line 363, column 9)",
                                                      " (in 'string', line 359, column 29 to line 364, column 7)",
                                                      " (in 'string', line 359, column 6 to line 370, column 7)",
                                                      " (in 'string', line 343, column 4 to line 371, column 5)",
                                                      " (in 'string', line 279, column 17 to line 373, column 3)",
                                                      " (in 'string', line 279, column 2 to line 373, column 3)",
                                                      " (in 'string', line 261, column 2 to column 54)",
                                                      " (in 'string', line 262, column 2 to column 53)",
                                                      " (in 'string', line 263, column 2 to column 53)",
                                                      " (in 'string', line 267, column 2 to column 38)",
                                                      " (in 'string', line 162, column 2 to column 23)",
                                                      " (in 'string', line 163, column 2 to column 21)",
                                                      " (in 'string', line 164, column 2 to column 21)",
                                                      " (in 'string', line 165, column 2 to column 17)",
                                                      " (in 'string', line 166, column 2 to column 17)",
                                                      " (in 'string', line 167, column 2 to column 17)",
                                                      " (in 'string', line 168, column 2 to column 21)",
                                                      " (in 'string', line 169, column 9 to column 10)",
                                                      " (in 'string', line 169, column 12 to column 19)",
                                                      " (in 'string', line 169, column 2 to column 32)",
                                                      " (in 'string', line 170, column 9 to column 10)",
                                                      " (in 'string', line 170, column 12 to column 13)",
                                                      " (in 'string', line 170, column 2 to column 23)",
                                                      " (in 'string', line 171, column 9 to column 10)",
                                                      " (in 'string', line 171, column 2 to column 14)",
                                                      " (in 'string', line 172, column 22 to column 23)",
                                                      " (in 'string', line 172, column 2 to column 25)",
                                                      " (in 'string', line 173, column 2 to column 23)",
                                                      " (in 'string', line 174, column 2 to column 30)",
                                                      " (in 'string', line 175, column 2 to column 21)",
                                                      " (in 'string', line 176, column 2 to column 28)",
                                                      " (in 'string', line 177, column 2 to column 21)",
                                                      " (in 'string', line 178, column 2 to column 28)",
                                                      " (in 'string', line 180, column 2 to column 32)",
                                                      " (in 'string', line 181, column 2 to column 32)",
                                                      " (in 'string', line 182, column 2 to column 31)",
                                                      " (in 'string', line 183, column 2 to column 31)",
                                                      " (in 'string', line 185, column 2 to column 24)",
                                                      " (in 'string', line 186, column 2 to column 22)",
                                                      " (in 'string', line 188, column 9 to column 10)",
                                                      " (in 'string', line 188, column 2 to column 15)",
                                                      " (in 'string', line 189, column 9 to column 10)",
                                                      " (in 'string', line 189, column 2 to column 23)",
                                                      " (in 'string', line 190, column 17 to column 18)",
                                                      " (in 'string', line 190, column 2 to column 20)",
                                                      " (in 'string', line 191, column 2 to column 19)",
                                                      " (in 'string', line 192, column 2 to column 17)",
                                                      " (in 'string', line 193, column 9 to column 14)",
                                                      " (in 'string', line 193, column 16 to column 17)",
                                                      " (in 'string', line 193, column 2 to column 29)",
                                                      " (in 'string', line 194, column 9 to column 14)",
                                                      " (in 'string', line 194, column 16 to column 17)",
                                                      " (in 'string', line 194, column 2 to column 29)",
                                                      " (in 'string', line 198, column 14 to column 42)",
                                                      " (in 'string', line 198, column 2 to column 44)",
                                                      " (in 'string', line 199, column 9 to column 10)",
                                                      " (in 'string', line 199, column 2 to column 15)",
                                                      " (in 'string', line 200, column 9 to column 10)",
                                                      " (in 'string', line 200, column 12 to column 13)",
                                                      " (in 'string', line 200, column 2 to column 42)",
                                                      " (in 'string', line 201, column 9 to column 10)",
                                                      " (in 'string', line 201, column 12 to column 13)",
                                                      " (in 'string', line 201, column 2 to column 52)",
                                                      " (in 'string', line 203, column 4 to column 15)",
                                                      " (in 'string', line 206, column 8 to column 20)",
                                                      " (in 'string', line 207, column 8 to column 24)",
                                                      " (in 'string', line 205, column 25 to line 208, column 7)",
                                                      " (in 'string', line 205, column 6 to line 208, column 7)",
                                                      " (in 'string', line 204, column 22 to line 209, column 5)",
                                                      " (in 'string', line 204, column 4 to line 209, column 5)",
                                                      " (in 'string', line 202, column 2 to line 210, column 3)",
                                                      " (in 'string', line 212, column 4 to column 67)",
                                                      " (in 'string', line 211, column 16 to line 213, column 3)",
                                                      " (in 'string', line 211, column 2 to line 213, column 3)",
                                                      " (in 'string', line 216, column 4 to column 26)",
                                                      " (in 'string', line 217, column 4 to column 29)",
                                                      " (in 'string', line 215, column 20 to line 218, column 3)",
                                                      " (in 'string', line 215, column 2 to line 218, column 3)",
                                                      " (in 'string', line 220, column 4 to column 26)",
                                                      " (in 'string', line 221, column 4 to column 29)",
                                                      " (in 'string', line 219, column 26 to line 222, column 3)",
                                                      " (in 'string', line 219, column 2 to line 222, column 3)",
                                                      " (in 'string', line 224, column 4 to column 20)",
                                                      " (in 'string', line 225, column 4 to column 23)",
                                                      " (in 'string', line 223, column 22 to line 226, column 3)",
                                                      " (in 'string', line 223, column 2 to line 226, column 3)",
                                                      " (in 'string', line 230, column 9 to column 16)",
                                                      " (in 'string', line 231, column 26 to column 31)",
                                                      " (in 'string', line 232, column 26 to column 31)",
                                                      " (in 'string', line 235, column 9 to column 10)",
                                                      " (in 'string', line 235, column 12 to column 13)",
                                                      " (in 'string', line 236, column 9 to column 10)",
                                                      " (in 'string', line 237, column 9 to column 10)",
                                                      " (in 'string', line 238, column 9 to column 10)",
                                                      " (in 'string', line 271, column 9 to column 10)",
                                                      " (in 'string', line 271, column 12 to column 28)",
                                                      " (in 'string', line 272, column 9 to column 14)",
                                                      " (in 'string', line 272, column 16 to column 32)",
                                                      " (in 'string', line 274, column 9 to column 25)",
                                                      " (in 'string', line 275, column 9 to column 25)",
                                                      " (in 'string', line 277, column 9 to column 10)",
                                                      " (in 'string', line 17, column 4 to column 23)",
                                                      " (in 'string', line 18, column 4 to column 20)",
                                                      " (in 'string', line 19, column 4 to column 21)",
                                                      " (in 'string', line 20, column 11 to column 12)",
                                                      " (in 'string', line 20, column 4 to column 64)",
                                                      " (in 'string', line 21, column 11 to column 12)",
                                                      " (in 'string', line 21, column 4 to column 21)",
                                                      " (in 'string', line 22, column 11 to column 12)",
                                                      " (in 'string', line 22, column 14 to column 15)",
                                                      " (in 'string', line 22, column 4 to column 24)",
                                                      " (in 'string', line 23, column 11 to column 12)",
                                                      " (in 'string', line 23, column 4 to column 16)",
                                                      " (in 'string', line 24, column 11 to column 12)",
                                                      " (in 'string', line 24, column 4 to column 16)",
                                                      " (in 'string', line 25, column 11 to column 12)",
                                                      " (in 'string', line 25, column 14 to column 15)",
                                                      " (in 'string', line 25, column 4 to column 19)",
                                                      " (in 'string', line 26, column 11 to column 12)",
                                                      " (in 'string', line 26, column 14 to column 17)",
                                                      " (in 'string', line 26, column 4 to column 21)",
                                                      " (in 'string', line 27, column 11 to column 12)",
                                                      " (in 'string', line 27, column 4 to column 19)",
                                                      " (in 'string', line 29, column 4 to column 30)",
                                                      " (in 'string', line 33, column 6 to column 55)",
                                                      " (in 'string', line 45, column 8 to column 19)",
                                                      " (in 'string', line 46, column 8 to column 34)",
                                                      " (in 'string', line 48, column 10 to column 30)",
                                                      " (in 'string', line 47, column 23 to line 49, column 9)",
                                                      " (in 'string', line 47, column 8 to line 49, column 9)",
                                                      " (in 'string', line 44, column 13 to line 50, column 7)",
                                                      " (in 'string', line 36, column 8 to column 57)",
                                                      " (in 'string', line 37, column 8 to column 48)",
                                                      " (in 'string', line 38, column 8 to column 36)",
                                                      " (in 'string', line 39, column 8 to column 58)",
                                                      " (in 'string', line 41, column 10 to column 30)",
                                                      " (in 'string', line 40, column 23 to line 42, column 9)",
                                                      " (in 'string', line 40, column 8 to line 42, column 9)",
                                                      " (in 'string', line 43, column 8 to column 72)",
                                                      " (in 'string', line 35, column 26 to line 44, column 7)",
                                                      " (in 'string', line 35, column 6 to line 50, column 7)",
                                                      " (in 'string', line 31, column 19 to line 51, column 5)",
                                                      " (in 'string', line 31, column 4 to line 51, column 5)",
                                                      " (in 'string', line 53, column 4 to column 33)",
                                                      " (in 'string', line 55, column 6 to column 25)",
                                                      " (in 'string', line 56, column 13 to column 14)",
                                                      " (in 'string', line 56, column 6 to column 31)",
                                                      " (in 'string', line 62, column 8 to column 26)",
                                                      " (in 'string', line 61, column 13 to line 63, column 7)",
                                                      " (in 'string', line 58, column 15 to column 16)",
                                                      " (in 'string', line 58, column 8 to column 44)",
                                                      " (in 'string', line 59, column 8 to column 30)",
                                                      " (in 'string', line 60, column 8 to column 71)",
                                                      " (in 'string', line 57, column 25 to line 61, column 7)",
                                                      " (in 'string', line 57, column 6 to line 63, column 7)",
                                                      " (in 'string', line 54, column 20 to line 64, column 5)",
                                                      " (in 'string', line 54, column 4 to line 64, column 5)",
                                                      " (in 'string', line 66, column 4 to column 17)",
                                                      " (in 'string', line 67, column 4 to column 27)",
                                                      " (in 'string', line 69, column 13 to column 14)",
                                                      " (in 'string', line 69, column 6 to column 30)",
                                                      " (in 'string', line 70, column 13 to column 14)",
                                                      " (in 'string', line 70, column 6 to column 29)",
                                                      " (in 'string', line 71, column 6 to column 41)",
                                                      " (in 'string', line 68, column 19 to line 72, column 5)",
                                                      " (in 'string', line 68, column 4 to line 72, column 5)",
                                                      " (in 'string', line 87, column 10 to column 59)",
                                                      " (in 'string', line 88, column 10 to line 90, column 44)",
                                                      " (in 'string', line 86, column 27 to line 91, column 9)",
                                                      " (in 'string', line 86, column 8 to line 91, column 9)",
                                                      " (in 'string', line 85, column 20 to line 92, column 7)",
                                                      " (in 'string', line 85, column 6 to line 92, column 7)",
                                                      " (in 'string', line 84, column 11 to line 93, column 5)",
                                                      " (in 'string', line 78, column 10 to column 59)",
                                                      " (in 'string', line 79, column 10 to line 81, column 44)",
                                                      " (in 'string', line 77, column 27 to line 82, column 9)",
                                                      " (in 'string', line 77, column 8 to line 82, column 9)",
                                                      " (in 'string', line 76, column 20 to line 83, column 7)",
                                                      " (in 'string', line 76, column 6 to line 83, column 7)",
                                                      " (in 'string', line 75, column 27 to line 84, column 5)",
                                                      " (in 'string', line 75, column 4 to line 93, column 5)",
                                                      " (in 'string', line 94, column 4 to column 18)",
                                                      " (in 'string', line 15, column 41 to line 95, column 3)",
                                                      " (in 'string', line 104, column 4 to column 23)",
                                                      " (in 'string', line 105, column 4 to column 20)",
                                                      " (in 'string', line 106, column 4 to column 21)",
                                                      " (in 'string', line 107, column 11 to column 12)",
                                                      " (in 'string', line 107, column 4 to column 21)",
                                                      " (in 'string', line 108, column 11 to column 12)",
                                                      " (in 'string', line 108, column 14 to column 15)",
                                                      " (in 'string', line 108, column 4 to column 24)",
                                                      " (in 'string', line 109, column 11 to column 12)",
                                                      " (in 'string', line 109, column 4 to column 16)",
                                                      " (in 'string', line 110, column 11 to column 12)",
                                                      " (in 'string', line 110, column 4 to column 16)",
                                                      " (in 'string', line 111, column 11 to column 12)",
                                                      " (in 'string', line 111, column 14 to column 15)",
                                                      " (in 'string', line 111, column 4 to column 19)",
                                                      " (in 'string', line 112, column 11 to column 12)",
                                                      " (in 'string', line 112, column 14 to column 17)",
                                                      " (in 'string', line 112, column 4 to column 21)",
                                                      " (in 'string', line 113, column 11 to column 12)",
                                                      " (in 'string', line 113, column 4 to column 19)",
                                                      " (in 'string', line 117, column 6 to column 55)",
                                                      " (in 'string', line 128, column 8 to column 19)",
                                                      " (in 'string', line 129, column 8 to column 34)",
                                                      " (in 'string', line 131, column 10 to column 30)",
                                                      " (in 'string', line 130, column 23 to line 132, column 9)",
                                                      " (in 'string', line 130, column 8 to line 132, column 9)",
                                                      " (in 'string', line 127, column 13 to line 133, column 7)",
                                                      " (in 'string', line 120, column 8 to column 57)",
                                                      " (in 'string', line 121, column 8 to column 48)",
                                                      " (in 'string', line 122, column 8 to column 36)",
                                                      " (in 'string', line 123, column 8 to column 58)",
                                                      " (in 'string', line 125, column 10 to column 30)",
                                                      " (in 'string', line 124, column 23 to line 126, column 9)",
                                                      " (in 'string', line 124, column 8 to line 126, column 9)",
                                                      " (in 'string', line 119, column 26 to line 127, column 7)",
                                                      " (in 'string', line 119, column 6 to line 133, column 7)",
                                                      " (in 'string', line 115, column 19 to line 134, column 5)",
                                                      " (in 'string', line 115, column 4 to line 134, column 5)",
                                                      " (in 'string', line 136, column 4 to column 36)",
                                                      " (in 'string', line 138, column 6 to column 25)",
                                                      " (in 'string', line 139, column 13 to column 14)",
                                                      " (in 'string', line 139, column 6 to column 31)",
                                                      " (in 'string', line 145, column 8 to column 27)",
                                                      " (in 'string', line 144, column 13 to line 146, column 7)",
                                                      " (in 'string', line 141, column 15 to column 16)",
                                                      " (in 'string', line 141, column 8 to column 44)",
                                                      " (in 'string', line 142, column 8 to column 30)",
                                                      " (in 'string', line 143, column 8 to column 71)",
                                                      " (in 'string', line 140, column 25 to line 144, column 7)",
                                                      " (in 'string', line 140, column 6 to line 146, column 7)",
                                                      " (in 'string', line 137, column 20 to line 147, column 5)",
                                                      " (in 'string', line 137, column 4 to line 147, column 5)",
                                                      " (in 'string', line 149, column 4 to column 17)",
                                                      " (in 'string', line 150, column 4 to column 27)",
                                                      " (in 'string', line 152, column 13 to column 14)",
                                                      " (in 'string', line 152, column 6 to column 30)",
                                                      " (in 'string', line 153, column 13 to column 14)",
                                                      " (in 'string', line 153, column 6 to column 29)",
                                                      " (in 'string', line 154, column 6 to column 41)",
                                                      " (in 'string', line 151, column 19 to line 155, column 5)",
                                                      " (in 'string', line 151, column 4 to line 155, column 5)",
                                                      " (in 'string', line 157, column 4 to column 23)",
                                                      " (in 'string', line 102, column 37 to line 158, column 3)"};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>, stan::value_type_t<T10__>,
stan::value_type_t<T11__>>>, -1, -1>
glm_approx_loglik(const T0__& y_arg__, const std::vector<int>& y_miss,
                  const T2__& a1_arg__, const T3__& P1_arg__,
                  const T4__& Ht_arg__, const T5__& Tt_arg__,
                  const T6__& Rt_arg__, const T7__& xreg_arg__,
                  const int& distribution, const std::vector<int>& u,
                  const T10__& y_original_arg__,
                  const T11__& xbeta_fixed_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>,
          stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
          stan::value_type_t<T7__>,
          stan::value_type_t<T10__>,
          stan::value_type_t<T11__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Ht = to_ref(Ht_arg__);
  const auto& Tt = to_ref(Tt_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  const auto& y_original = to_ref(y_original_arg__);
  const auto& xbeta_fixed = to_ref(xbeta_fixed_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int k;
    k = std::numeric_limits<int>::min();
    
    current_statement__ = 208;
    k = rows(xreg);
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 209;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 210;
    m = rows(a1);
    current_statement__ = 211;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, -1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, -1>(n, 2);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 212;
    assign(loglik, nil_index_list(),
      rep_matrix(stan::math::negative_infinity(), n, 2),
      "assigning variable loglik");
    current_statement__ = 213;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 214;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 215;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 216;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 217;
    assign(P, nil_index_list(), P1, "assigning variable P");
    current_statement__ = 218;
    validate_non_negative_index("v", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> v;
    v = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(v, DUMMY_VAR__);
    
    current_statement__ = 220;
    validate_non_negative_index("F", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> F;
    F = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(F, DUMMY_VAR__);
    
    current_statement__ = 222;
    validate_non_negative_index("K", "m", m);
    current_statement__ = 223;
    validate_non_negative_index("K", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, -1> K;
    K = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
    stan::math::fill(K, DUMMY_VAR__);
    
    current_statement__ = 225;
    validate_non_negative_index("r", "m", m);
    current_statement__ = 226;
    validate_non_negative_index("r", "n + 1", (n + 1));
    Eigen::Matrix<local_scalar_t__, -1, -1> r;
    r = Eigen::Matrix<local_scalar_t__, -1, -1>(m, (n + 1));
    stan::math::fill(r, DUMMY_VAR__);
    
    current_statement__ = 228;
    validate_non_negative_index("tmpr", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> tmpr;
    tmpr = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(tmpr, DUMMY_VAR__);
    
    local_scalar_t__ log2pi;
    log2pi = DUMMY_VAR__;
    
    current_statement__ = 230;
    log2pi = stan::math::log((2 * stan::math::pi()));
    current_statement__ = 249;
    for (int t = 1; t <= n; ++t) {
      current_statement__ = 231;
      assign(F, cons_list(index_uni(t), nil_index_list()),
        (quad_form(
           rvalue(P,
             cons_list(index_min_max(1, k),
               cons_list(index_min_max(1, k), nil_index_list())), "P"),
           rvalue(xreg,
             cons_list(index_omni(),
               cons_list(index_uni(t), nil_index_list())), "xreg")) +
          Ht[(t - 1)]), "assigning variable F");
      current_statement__ = 247;
      if (logical_eq(y_miss[(t - 1)], 0)) {
        current_statement__ = 238;
        assign(v, cons_list(index_uni(t), nil_index_list()),
          (y[(t - 1)] -
            dot_product(
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg"),
              head(x, k))), "assigning variable v");
        current_statement__ = 239;
        assign(K,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          divide(
            multiply(
              rvalue(P,
                cons_list(index_min_max(1, m),
                  cons_list(index_min_max(1, k), nil_index_list())), "P"),
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg")),
            F[(t - 1)]), "assigning variable K");
        current_statement__ = 240;
        assign(x, nil_index_list(),
          multiply(Tt,
            add(stan::model::deep_copy(x),
              multiply(
                rvalue(K,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "K"),
                v[(t - 1)]))), "assigning variable x");
        current_statement__ = 241;
        assign(P, nil_index_list(),
          quad_form_sym(
            subtract(stan::model::deep_copy(P),
              multiply(
                multiply(
                  rvalue(K,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "K"),
                  transpose(
                    rvalue(K,
                      cons_list(index_omni(),
                        cons_list(index_uni(t), nil_index_list())), "K"))),
                F[(t - 1)])), transpose(Tt)), "assigning variable P");
        current_statement__ = 244;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 242;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
        current_statement__ = 245;
        assign(loglik,
          cons_list(index_uni(t), cons_list(index_uni(1), nil_index_list())),
          (-0.5 *
            ((log2pi + stan::math::log(F[(t - 1)])) +
              ((v[(t - 1)] * v[(t - 1)]) / F[(t - 1)]))),
          "assigning variable loglik");
      } else {
        current_statement__ = 232;
        assign(x, nil_index_list(), multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 233;
        assign(P, nil_index_list(),
          quad_form_sym(stan::model::deep_copy(P), transpose(Tt)),
          "assigning variable P");
        current_statement__ = 236;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 234;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      }}
    current_statement__ = 250;
    assign(r,
      cons_list(index_omni(),
        cons_list(index_uni((n + 1)), nil_index_list())), rep_vector(0.0, m),
      "assigning variable r");
    current_statement__ = 263;
    for (int tt = 1; tt <= n; ++tt) {
      int t;
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 251;
      t = ((n + 1) - tt);
      current_statement__ = 252;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 253;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t + 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 261;
      if (logical_eq(y_miss[(t - 1)], 0)) {
        current_statement__ = 256;
        validate_non_negative_index("tmp2", "m", m);
        Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
        tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
        stan::math::fill(tmp2, DUMMY_VAR__);
        
        current_statement__ = 257;
        assign(tmp2, nil_index_list(), rep_vector(0.0, m),
          "assigning variable tmp2");
        current_statement__ = 258;
        assign(tmp2, cons_list(index_min_max(1, k), nil_index_list()),
          rvalue(xreg,
            cons_list(index_omni(),
              cons_list(index_uni(t), nil_index_list())), "xreg"),
          "assigning variable tmp2");
        current_statement__ = 259;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          add(divide(multiply(tmp2, v[(t - 1)]), F[(t - 1)]),
            multiply(
              transpose(
                subtract(Tt,
                  multiply(
                    multiply(Tt,
                      rvalue(K,
                        cons_list(index_omni(),
                          cons_list(index_uni(t), nil_index_list())), "K")),
                    transpose(tmp2)))), tmp)), "assigning variable r");
      } else {
        current_statement__ = 254;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          multiply(transpose(Tt), tmp), "assigning variable r");
      }}
    current_statement__ = 264;
    assign(tmpr, nil_index_list(),
      rvalue(r,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        "r"), "assigning variable tmpr");
    current_statement__ = 265;
    assign(r,
      cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
      add(a1, multiply(P1, tmpr)), "assigning variable r");
    current_statement__ = 272;
    for (int t = 2; t <= n; ++t) {
      current_statement__ = 266;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 267;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t - 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 268;
      validate_non_negative_index("tmp2", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
      tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp2, DUMMY_VAR__);
      
      current_statement__ = 269;
      assign(tmp2, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          "r"), "assigning variable tmp2");
      current_statement__ = 270;
      assign(r,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        add(multiply(Tt, tmp),
          elt_multiply(
            rvalue(Rt,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "Rt"), tmp2)),
        "assigning variable r");}
    current_statement__ = 287;
    if (logical_eq(distribution, 1)) {
      current_statement__ = 285;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 283;
        if (logical_eq(y_miss[(t - 1)], 0)) {
          local_scalar_t__ xbeta_rw;
          xbeta_rw = DUMMY_VAR__;
          
          current_statement__ = 280;
          xbeta_rw = dot_product(
                       rvalue(xreg,
                         cons_list(index_omni(),
                           cons_list(index_uni(t), nil_index_list())),
                         "xreg"),
                       rvalue(r,
                         cons_list(index_min_max(1, k),
                           cons_list(index_uni(t), nil_index_list())), "r"));
          current_statement__ = 281;
          assign(loglik,
            cons_list(index_uni(t),
              cons_list(index_uni(2), nil_index_list())),
            (((y_original[(t - 1)] * (xbeta_rw + xbeta_fixed[(t - 1)])) -
               (u[(t - 1)] *
                 stan::math::exp((xbeta_rw + xbeta_fixed[(t - 1)])))) +
              ((0.5 * pow((y[(t - 1)] - xbeta_rw), 2)) / Ht[(t - 1)])),
            "assigning variable loglik");
        } }
    } else {
      current_statement__ = 278;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 276;
        if (logical_eq(y_miss[(t - 1)], 0)) {
          local_scalar_t__ xbeta_rw;
          xbeta_rw = DUMMY_VAR__;
          
          current_statement__ = 273;
          xbeta_rw = dot_product(
                       rvalue(xreg,
                         cons_list(index_omni(),
                           cons_list(index_uni(t), nil_index_list())),
                         "xreg"),
                       rvalue(r,
                         cons_list(index_min_max(1, k),
                           cons_list(index_uni(t), nil_index_list())), "r"));
          current_statement__ = 274;
          assign(loglik,
            cons_list(index_uni(t),
              cons_list(index_uni(2), nil_index_list())),
            (((y_original[(t - 1)] * (xbeta_rw + xbeta_fixed[(t - 1)])) -
               (u[(t - 1)] *
                 stan::math::log1p(
                   stan::math::exp((xbeta_rw + xbeta_fixed[(t - 1)]))))) +
              ((0.5 * pow((y[(t - 1)] - xbeta_rw), 2)) / Ht[(t - 1)])),
            "assigning variable loglik");
        } }
    }
    current_statement__ = 288;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct glm_approx_loglik_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>, stan::value_type_t<T10__>,
stan::value_type_t<T11__>>>, -1, -1>
operator()(const T0__& y, const std::vector<int>& y_miss, const T2__& a1,
           const T3__& P1, const T4__& Ht, const T5__& Tt, const T6__& Rt,
           const T7__& xreg, const int& distribution,
           const std::vector<int>& u, const T10__& y_original,
           const T11__& xbeta_fixed, std::ostream* pstream__)  const 
{
return glm_approx_loglik(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, distribution,
         u, y_original, xbeta_fixed, pstream__);
}
};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>>>, -1, -1>
glm_approx_smoother(const T0__& y_arg__, const std::vector<int>& y_miss,
                    const T2__& a1_arg__, const T3__& P1_arg__,
                    const T4__& Ht_arg__, const T5__& Tt_arg__,
                    const T6__& Rt_arg__, const T7__& xreg_arg__,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>,
          stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
          stan::value_type_t<T7__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Ht = to_ref(Ht_arg__);
  const auto& Tt = to_ref(Tt_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int k;
    k = std::numeric_limits<int>::min();
    
    current_statement__ = 290;
    k = rows(xreg);
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 291;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 292;
    m = rows(a1);
    current_statement__ = 293;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 294;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 295;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 296;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 297;
    assign(P, nil_index_list(), P1, "assigning variable P");
    current_statement__ = 298;
    validate_non_negative_index("v", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> v;
    v = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(v, DUMMY_VAR__);
    
    current_statement__ = 300;
    validate_non_negative_index("F", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> F;
    F = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(F, DUMMY_VAR__);
    
    current_statement__ = 302;
    validate_non_negative_index("K", "m", m);
    current_statement__ = 303;
    validate_non_negative_index("K", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, -1> K;
    K = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
    stan::math::fill(K, DUMMY_VAR__);
    
    current_statement__ = 305;
    validate_non_negative_index("r", "m", m);
    current_statement__ = 306;
    validate_non_negative_index("r", "n + 1", (n + 1));
    Eigen::Matrix<local_scalar_t__, -1, -1> r;
    r = Eigen::Matrix<local_scalar_t__, -1, -1>(m, (n + 1));
    stan::math::fill(r, DUMMY_VAR__);
    
    current_statement__ = 308;
    validate_non_negative_index("tmpr", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> tmpr;
    tmpr = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(tmpr, DUMMY_VAR__);
    
    current_statement__ = 327;
    for (int t = 1; t <= n; ++t) {
      current_statement__ = 310;
      assign(F, cons_list(index_uni(t), nil_index_list()),
        (quad_form(
           rvalue(P,
             cons_list(index_min_max(1, k),
               cons_list(index_min_max(1, k), nil_index_list())), "P"),
           rvalue(xreg,
             cons_list(index_omni(),
               cons_list(index_uni(t), nil_index_list())), "xreg")) +
          Ht[(t - 1)]), "assigning variable F");
      current_statement__ = 325;
      if (logical_eq(y_miss[(t - 1)], 0)) {
        current_statement__ = 317;
        assign(v, cons_list(index_uni(t), nil_index_list()),
          (y[(t - 1)] -
            dot_product(
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg"),
              head(x, k))), "assigning variable v");
        current_statement__ = 318;
        assign(K,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          divide(
            multiply(
              rvalue(P,
                cons_list(index_min_max(1, m),
                  cons_list(index_min_max(1, k), nil_index_list())), "P"),
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg")),
            F[(t - 1)]), "assigning variable K");
        current_statement__ = 319;
        assign(x, nil_index_list(),
          multiply(Tt,
            add(stan::model::deep_copy(x),
              multiply(
                rvalue(K,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "K"),
                v[(t - 1)]))), "assigning variable x");
        current_statement__ = 320;
        assign(P, nil_index_list(),
          quad_form_sym(
            subtract(stan::model::deep_copy(P),
              multiply(
                multiply(
                  rvalue(K,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "K"),
                  transpose(
                    rvalue(K,
                      cons_list(index_omni(),
                        cons_list(index_uni(t), nil_index_list())), "K"))),
                F[(t - 1)])), transpose(Tt)), "assigning variable P");
        current_statement__ = 323;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 321;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      } else {
        current_statement__ = 311;
        assign(x, nil_index_list(), multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 312;
        assign(P, nil_index_list(),
          quad_form_sym(stan::model::deep_copy(P), transpose(Tt)),
          "assigning variable P");
        current_statement__ = 315;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 313;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      }}
    current_statement__ = 328;
    assign(r,
      cons_list(index_omni(),
        cons_list(index_uni((n + 1)), nil_index_list())), rep_vector(0.0, m),
      "assigning variable r");
    current_statement__ = 341;
    for (int tt = 1; tt <= n; ++tt) {
      int t;
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 329;
      t = ((n + 1) - tt);
      current_statement__ = 330;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 331;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t + 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 339;
      if (logical_eq(y_miss[(t - 1)], 0)) {
        current_statement__ = 334;
        validate_non_negative_index("tmp2", "m", m);
        Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
        tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
        stan::math::fill(tmp2, DUMMY_VAR__);
        
        current_statement__ = 335;
        assign(tmp2, nil_index_list(), rep_vector(0.0, m),
          "assigning variable tmp2");
        current_statement__ = 336;
        assign(tmp2, cons_list(index_min_max(1, k), nil_index_list()),
          rvalue(xreg,
            cons_list(index_omni(),
              cons_list(index_uni(t), nil_index_list())), "xreg"),
          "assigning variable tmp2");
        current_statement__ = 337;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          add(divide(multiply(tmp2, v[(t - 1)]), F[(t - 1)]),
            multiply(
              transpose(
                subtract(Tt,
                  multiply(
                    multiply(Tt,
                      rvalue(K,
                        cons_list(index_omni(),
                          cons_list(index_uni(t), nil_index_list())), "K")),
                    transpose(tmp2)))), tmp)), "assigning variable r");
      } else {
        current_statement__ = 332;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          multiply(transpose(Tt), tmp), "assigning variable r");
      }}
    current_statement__ = 342;
    assign(tmpr, nil_index_list(),
      rvalue(r,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        "r"), "assigning variable tmpr");
    current_statement__ = 343;
    assign(r,
      cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
      add(a1, multiply(P1, tmpr)), "assigning variable r");
    current_statement__ = 350;
    for (int t = 2; t <= n; ++t) {
      current_statement__ = 344;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 345;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t - 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 346;
      validate_non_negative_index("tmp2", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
      tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp2, DUMMY_VAR__);
      
      current_statement__ = 347;
      assign(tmp2, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          "r"), "assigning variable tmp2");
      current_statement__ = 348;
      assign(r,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        add(multiply(Tt, tmp),
          elt_multiply(
            rvalue(Rt,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "Rt"), tmp2)),
        "assigning variable r");}
    current_statement__ = 351;
    return rvalue(r,
             cons_list(index_min_max(1, m),
               cons_list(index_min_max(1, n), nil_index_list())), "r");
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct glm_approx_smoother_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, stan::value_type_t<T4__>,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>>>, -1, -1>
operator()(const T0__& y, const std::vector<int>& y_miss, const T2__& a1,
           const T3__& P1, const T4__& Ht, const T5__& Tt, const T6__& Rt,
           const T7__& xreg, std::ostream* pstream__)  const 
{
return glm_approx_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_walker_glm final : public model_base_crtp<model_walker_glm> {
private:
  int k_fixed;
  int k_rw1;
  int k_rw2;
  int m;
  int k;
  int n;
  int n_lfo;
  Eigen::Matrix<double, -1, -1> xreg_fixed;
  Eigen::Matrix<double, -1, -1> xreg_rw;
  Eigen::Matrix<double, -1, 1> y;
  std::vector<int> y_miss;
  double beta_fixed_mean;
  double beta_fixed_sd;
  double beta_rw1_mean;
  double beta_rw1_sd;
  double beta_rw2_mean;
  double beta_rw2_sd;
  double sigma_rw1_shape;
  double sigma_rw2_shape;
  double sigma_rw1_rate;
  double sigma_rw2_rate;
  double nu_mean;
  double nu_sd;
  Eigen::Matrix<double, -1, 1> Ht;
  Eigen::Matrix<double, -1, 1> y_original;
  std::vector<int> u;
  int distribution;
  int N;
  Eigen::Matrix<double, -1, -1> gamma_rw1;
  Eigen::Matrix<double, -1, -1> gamma_rw2;
  std::vector<int> obs_idx;
  Eigen::Matrix<double, -1, 1> a1;
  Eigen::Matrix<double, -1, -1> P1;
  Eigen::Matrix<double, -1, -1> Tt;
  int beta_rw_2dim__;
  int nu_2dim__;
  int y_fit_1dim__;
  int y_rep_1dim__;
 
public:
  ~model_walker_glm() { }
  
  inline std::string model_name() const final { return "model_walker_glm"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_walker_glm(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_walker_glm_namespace::model_walker_glm";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 117;
      context__.validate_dims("data initialization","k_fixed","int",
          context__.to_vec());
      k_fixed = std::numeric_limits<int>::min();
      
      current_statement__ = 117;
      k_fixed = context__.vals_i("k_fixed")[(1 - 1)];
      current_statement__ = 117;
      current_statement__ = 117;
      check_greater_or_equal(function__, "k_fixed", k_fixed, 0);
      current_statement__ = 118;
      context__.validate_dims("data initialization","k_rw1","int",
          context__.to_vec());
      k_rw1 = std::numeric_limits<int>::min();
      
      current_statement__ = 118;
      k_rw1 = context__.vals_i("k_rw1")[(1 - 1)];
      current_statement__ = 118;
      current_statement__ = 118;
      check_greater_or_equal(function__, "k_rw1", k_rw1, 0);
      current_statement__ = 119;
      context__.validate_dims("data initialization","k_rw2","int",
          context__.to_vec());
      k_rw2 = std::numeric_limits<int>::min();
      
      current_statement__ = 119;
      k_rw2 = context__.vals_i("k_rw2")[(1 - 1)];
      current_statement__ = 119;
      current_statement__ = 119;
      check_greater_or_equal(function__, "k_rw2", k_rw2, 0);
      current_statement__ = 120;
      context__.validate_dims("data initialization","m","int",
          context__.to_vec());
      m = std::numeric_limits<int>::min();
      
      current_statement__ = 120;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 120;
      current_statement__ = 120;
      check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 121;
      context__.validate_dims("data initialization","k","int",
          context__.to_vec());
      k = std::numeric_limits<int>::min();
      
      current_statement__ = 121;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 121;
      current_statement__ = 121;
      check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 122;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 122;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 122;
      current_statement__ = 122;
      check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 123;
      context__.validate_dims("data initialization","n_lfo","int",
          context__.to_vec());
      n_lfo = std::numeric_limits<int>::min();
      
      current_statement__ = 123;
      n_lfo = context__.vals_i("n_lfo")[(1 - 1)];
      current_statement__ = 123;
      current_statement__ = 123;
      check_greater_or_equal(function__, "n_lfo", n_lfo, 1);
      current_statement__ = 124;
      validate_non_negative_index("xreg_fixed", "n", n);
      current_statement__ = 125;
      validate_non_negative_index("xreg_fixed", "k_fixed", k_fixed);
      current_statement__ = 126;
      context__.validate_dims("data initialization","xreg_fixed","double",
          context__.to_vec(n, k_fixed));
      xreg_fixed = Eigen::Matrix<double, -1, -1>(n, k_fixed);
      stan::math::fill(xreg_fixed, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_fixed_flat__;
        current_statement__ = 126;
        assign(xreg_fixed_flat__, nil_index_list(),
          context__.vals_r("xreg_fixed"),
          "assigning variable xreg_fixed_flat__");
        current_statement__ = 126;
        pos__ = 1;
        current_statement__ = 126;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 126;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 126;
            assign(xreg_fixed,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_fixed_flat__[(pos__ - 1)], "assigning variable xreg_fixed");
            current_statement__ = 126;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 127;
      validate_non_negative_index("xreg_rw", "k", k);
      current_statement__ = 128;
      validate_non_negative_index("xreg_rw", "n", n);
      current_statement__ = 129;
      context__.validate_dims("data initialization","xreg_rw","double",
          context__.to_vec(k, n));
      xreg_rw = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(xreg_rw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_rw_flat__;
        current_statement__ = 129;
        assign(xreg_rw_flat__, nil_index_list(), context__.vals_r("xreg_rw"),
          "assigning variable xreg_rw_flat__");
        current_statement__ = 129;
        pos__ = 1;
        current_statement__ = 129;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 129;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 129;
            assign(xreg_rw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_rw_flat__[(pos__ - 1)], "assigning variable xreg_rw");
            current_statement__ = 129;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 130;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 131;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 131;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 131;
        pos__ = 1;
        current_statement__ = 131;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 131;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 131;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 132;
      validate_non_negative_index("y_miss", "n", n);
      current_statement__ = 133;
      context__.validate_dims("data initialization","y_miss","int",
          context__.to_vec(n));
      y_miss = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 133;
      assign(y_miss, nil_index_list(), context__.vals_i("y_miss"),
        "assigning variable y_miss");
      current_statement__ = 133;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 133;
        current_statement__ = 133;
        check_greater_or_equal(function__, "y_miss[sym1__]",
                               y_miss[(sym1__ - 1)], 0);}
      current_statement__ = 134;
      context__.validate_dims("data initialization","beta_fixed_mean",
          "double",context__.to_vec());
      beta_fixed_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 134;
      beta_fixed_mean = context__.vals_r("beta_fixed_mean")[(1 - 1)];
      current_statement__ = 135;
      context__.validate_dims("data initialization","beta_fixed_sd","double",
          context__.to_vec());
      beta_fixed_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 135;
      beta_fixed_sd = context__.vals_r("beta_fixed_sd")[(1 - 1)];
      current_statement__ = 135;
      current_statement__ = 135;
      check_greater_or_equal(function__, "beta_fixed_sd", beta_fixed_sd, 0);
      current_statement__ = 136;
      context__.validate_dims("data initialization","beta_rw1_mean","double",
          context__.to_vec());
      beta_rw1_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 136;
      beta_rw1_mean = context__.vals_r("beta_rw1_mean")[(1 - 1)];
      current_statement__ = 137;
      context__.validate_dims("data initialization","beta_rw1_sd","double",
          context__.to_vec());
      beta_rw1_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 137;
      beta_rw1_sd = context__.vals_r("beta_rw1_sd")[(1 - 1)];
      current_statement__ = 137;
      current_statement__ = 137;
      check_greater_or_equal(function__, "beta_rw1_sd", beta_rw1_sd, 0);
      current_statement__ = 138;
      context__.validate_dims("data initialization","beta_rw2_mean","double",
          context__.to_vec());
      beta_rw2_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 138;
      beta_rw2_mean = context__.vals_r("beta_rw2_mean")[(1 - 1)];
      current_statement__ = 139;
      context__.validate_dims("data initialization","beta_rw2_sd","double",
          context__.to_vec());
      beta_rw2_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 139;
      beta_rw2_sd = context__.vals_r("beta_rw2_sd")[(1 - 1)];
      current_statement__ = 139;
      current_statement__ = 139;
      check_greater_or_equal(function__, "beta_rw2_sd", beta_rw2_sd, 0);
      current_statement__ = 140;
      context__.validate_dims("data initialization","sigma_rw1_shape",
          "double",context__.to_vec());
      sigma_rw1_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 140;
      sigma_rw1_shape = context__.vals_r("sigma_rw1_shape")[(1 - 1)];
      current_statement__ = 140;
      current_statement__ = 140;
      check_greater_or_equal(function__, "sigma_rw1_shape", sigma_rw1_shape,
                             0);
      current_statement__ = 141;
      context__.validate_dims("data initialization","sigma_rw2_shape",
          "double",context__.to_vec());
      sigma_rw2_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 141;
      sigma_rw2_shape = context__.vals_r("sigma_rw2_shape")[(1 - 1)];
      current_statement__ = 141;
      current_statement__ = 141;
      check_greater_or_equal(function__, "sigma_rw2_shape", sigma_rw2_shape,
                             0);
      current_statement__ = 142;
      context__.validate_dims("data initialization","sigma_rw1_rate",
          "double",context__.to_vec());
      sigma_rw1_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 142;
      sigma_rw1_rate = context__.vals_r("sigma_rw1_rate")[(1 - 1)];
      current_statement__ = 142;
      current_statement__ = 142;
      check_greater_or_equal(function__, "sigma_rw1_rate", sigma_rw1_rate, 0);
      current_statement__ = 143;
      context__.validate_dims("data initialization","sigma_rw2_rate",
          "double",context__.to_vec());
      sigma_rw2_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 143;
      sigma_rw2_rate = context__.vals_r("sigma_rw2_rate")[(1 - 1)];
      current_statement__ = 143;
      current_statement__ = 143;
      check_greater_or_equal(function__, "sigma_rw2_rate", sigma_rw2_rate, 0);
      current_statement__ = 144;
      context__.validate_dims("data initialization","nu_mean","double",
          context__.to_vec());
      nu_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 144;
      nu_mean = context__.vals_r("nu_mean")[(1 - 1)];
      current_statement__ = 144;
      current_statement__ = 144;
      check_greater_or_equal(function__, "nu_mean", nu_mean, 0);
      current_statement__ = 145;
      context__.validate_dims("data initialization","nu_sd","double",
          context__.to_vec());
      nu_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 145;
      nu_sd = context__.vals_r("nu_sd")[(1 - 1)];
      current_statement__ = 145;
      current_statement__ = 145;
      check_greater_or_equal(function__, "nu_sd", nu_sd, 0);
      current_statement__ = 146;
      validate_non_negative_index("Ht", "n", n);
      current_statement__ = 147;
      context__.validate_dims("data initialization","Ht","double",
          context__.to_vec(n));
      Ht = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(Ht, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Ht_flat__;
        current_statement__ = 147;
        assign(Ht_flat__, nil_index_list(), context__.vals_r("Ht"),
          "assigning variable Ht_flat__");
        current_statement__ = 147;
        pos__ = 1;
        current_statement__ = 147;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 147;
          assign(Ht, cons_list(index_uni(sym1__), nil_index_list()),
            Ht_flat__[(pos__ - 1)], "assigning variable Ht");
          current_statement__ = 147;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 148;
      validate_non_negative_index("y_original", "n", n);
      current_statement__ = 149;
      context__.validate_dims("data initialization","y_original","double",
          context__.to_vec(n));
      y_original = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y_original, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_original_flat__;
        current_statement__ = 149;
        assign(y_original_flat__, nil_index_list(),
          context__.vals_r("y_original"),
          "assigning variable y_original_flat__");
        current_statement__ = 149;
        pos__ = 1;
        current_statement__ = 149;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 149;
          assign(y_original, cons_list(index_uni(sym1__), nil_index_list()),
            y_original_flat__[(pos__ - 1)], "assigning variable y_original");
          current_statement__ = 149;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 150;
      validate_non_negative_index("u", "n", n);
      current_statement__ = 151;
      context__.validate_dims("data initialization","u","int",
          context__.to_vec(n));
      u = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 151;
      assign(u, nil_index_list(), context__.vals_i("u"),
        "assigning variable u");
      current_statement__ = 151;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 151;
        current_statement__ = 151;
        check_greater_or_equal(function__, "u[sym1__]", u[(sym1__ - 1)], 0);}
      current_statement__ = 152;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 152;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 153;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 153;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 153;
      current_statement__ = 153;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 154;
      validate_non_negative_index("gamma_rw1", "k_rw1", k_rw1);
      current_statement__ = 155;
      validate_non_negative_index("gamma_rw1", "n", n);
      current_statement__ = 156;
      context__.validate_dims("data initialization","gamma_rw1","double",
          context__.to_vec(k_rw1, n));
      gamma_rw1 = Eigen::Matrix<double, -1, -1>(k_rw1, n);
      stan::math::fill(gamma_rw1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_rw1_flat__;
        current_statement__ = 156;
        assign(gamma_rw1_flat__, nil_index_list(),
          context__.vals_r("gamma_rw1"),
          "assigning variable gamma_rw1_flat__");
        current_statement__ = 156;
        pos__ = 1;
        current_statement__ = 156;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 156;
          for (int sym2__ = 1; sym2__ <= k_rw1; ++sym2__) {
            current_statement__ = 156;
            assign(gamma_rw1,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              gamma_rw1_flat__[(pos__ - 1)], "assigning variable gamma_rw1");
            current_statement__ = 156;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 157;
      validate_non_negative_index("gamma_rw2", "k_rw2", k_rw2);
      current_statement__ = 158;
      validate_non_negative_index("gamma_rw2", "n", n);
      current_statement__ = 159;
      context__.validate_dims("data initialization","gamma_rw2","double",
          context__.to_vec(k_rw2, n));
      gamma_rw2 = Eigen::Matrix<double, -1, -1>(k_rw2, n);
      stan::math::fill(gamma_rw2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_rw2_flat__;
        current_statement__ = 159;
        assign(gamma_rw2_flat__, nil_index_list(),
          context__.vals_r("gamma_rw2"),
          "assigning variable gamma_rw2_flat__");
        current_statement__ = 159;
        pos__ = 1;
        current_statement__ = 159;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 159;
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            current_statement__ = 159;
            assign(gamma_rw2,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              gamma_rw2_flat__[(pos__ - 1)], "assigning variable gamma_rw2");
            current_statement__ = 159;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 160;
      validate_non_negative_index("obs_idx",
                                  "n_lfo - sum(y_miss[1 : n_lfo])",
                                  (n_lfo -
                                    sum(
                                      rvalue(y_miss,
                                        cons_list(index_min_max(1, n_lfo),
                                          nil_index_list()), "y_miss"))));
      current_statement__ = 161;
      obs_idx = std::vector<int>((n_lfo -
                                   sum(
                                     rvalue(y_miss,
                                       cons_list(index_min_max(1, n_lfo),
                                         nil_index_list()), "y_miss"))), std::numeric_limits<int>::min());
      
      current_statement__ = 162;
      validate_non_negative_index("a1", "m", m);
      current_statement__ = 163;
      a1 = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(a1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 164;
      validate_non_negative_index("P1", "m", m);
      current_statement__ = 165;
      validate_non_negative_index("P1", "m", m);
      current_statement__ = 166;
      P1 = Eigen::Matrix<double, -1, -1>(m, m);
      stan::math::fill(P1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 166;
      assign(P1, nil_index_list(), rep_matrix(0.0, m, m),
        "assigning variable P1");
      current_statement__ = 167;
      validate_non_negative_index("Tt", "m", m);
      current_statement__ = 168;
      validate_non_negative_index("Tt", "m", m);
      current_statement__ = 169;
      Tt = Eigen::Matrix<double, -1, -1>(m, m);
      stan::math::fill(Tt, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 169;
      assign(Tt, nil_index_list(), diag_matrix(rep_vector(1.0, m)),
        "assigning variable Tt");
      {
        int ii;
        ii = std::numeric_limits<int>::min();
        
        current_statement__ = 170;
        ii = 0;
        current_statement__ = 176;
        for (int i = 1; i <= n_lfo; ++i) {
          current_statement__ = 174;
          if (logical_eq(y_miss[(i - 1)], 0)) {
            current_statement__ = 171;
            ii = (ii + 1);
            current_statement__ = 172;
            assign(obs_idx, cons_list(index_uni(ii), nil_index_list()), i,
              "assigning variable obs_idx");
          } }
      }
      current_statement__ = 180;
      if (logical_gt(k_rw2, 0)) {
        current_statement__ = 178;
        assign(Tt,
          cons_list(index_min_max((k_rw1 + 1), k),
            cons_list(index_min_max((k + 1), m), nil_index_list())),
          diag_matrix(rep_vector(1.0, k_rw2)), "assigning variable Tt");
      } 
      current_statement__ = 184;
      for (int i = 1; i <= k_rw1; ++i) {
        current_statement__ = 181;
        assign(a1, cons_list(index_uni(i), nil_index_list()), beta_rw1_mean,
          "assigning variable a1");
        current_statement__ = 182;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(beta_rw1_sd, 2), "assigning variable P1");}
      current_statement__ = 188;
      for (int i = (k_rw1 + 1); i <= k; ++i) {
        current_statement__ = 185;
        assign(a1, cons_list(index_uni(i), nil_index_list()), beta_rw2_mean,
          "assigning variable a1");
        current_statement__ = 186;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(beta_rw2_sd, 2), "assigning variable P1");}
      current_statement__ = 192;
      for (int i = (k + 1); i <= m; ++i) {
        current_statement__ = 189;
        assign(a1, cons_list(index_uni(i), nil_index_list()), nu_mean,
          "assigning variable a1");
        current_statement__ = 190;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(nu_sd, 2), "assigning variable P1");}
      current_statement__ = 193;
      validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
      current_statement__ = 194;
      validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
      current_statement__ = 195;
      validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
      current_statement__ = 196;
      validate_non_negative_index("Rt", "m", m);
      current_statement__ = 197;
      validate_non_negative_index("Rt", "n", n);
      current_statement__ = 198;
      validate_non_negative_index("xbeta", "n", n);
      current_statement__ = 199;
      validate_non_negative_index("y_", "n", n);
      current_statement__ = 200;
      validate_non_negative_index("loglik", "n", n);
      current_statement__ = 201;
      validate_non_negative_index("beta_rw", "k", k);
      current_statement__ = 202;
      beta_rw_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 202;
      beta_rw_2dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 202;
      validate_non_negative_index("beta_rw", "n * (n_lfo == n)",
                                  beta_rw_2dim__);
      current_statement__ = 203;
      validate_non_negative_index("nu", "k_rw2", k_rw2);
      current_statement__ = 204;
      nu_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 204;
      nu_2dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 204;
      validate_non_negative_index("nu", "n * (n_lfo == n)", nu_2dim__);
      current_statement__ = 205;
      y_fit_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 205;
      y_fit_1dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 205;
      validate_non_negative_index("y_fit", "n * (n_lfo == n)", y_fit_1dim__);
      current_statement__ = 206;
      y_rep_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 206;
      y_rep_1dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 206;
      validate_non_negative_index("y_rep", "n * (n_lfo == n)", y_rep_1dim__);
      current_statement__ = 207;
      validate_non_negative_index("log_lik", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += k_fixed;
      num_params_r__ += k_rw1;
      num_params_r__ += k_rw2;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_walker_glm_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<local_scalar_t__, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta_fixed = in__.vector(k_fixed);
      std::vector<local_scalar_t__> sigma_rw1;
      sigma_rw1 = std::vector<local_scalar_t__>(k_rw1, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw1");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_rw1");
        } else {
          current_statement__ = 2;
          assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0),
            "assigning variable sigma_rw1");
        }}
      std::vector<local_scalar_t__> sigma_rw2;
      sigma_rw2 = std::vector<local_scalar_t__>(k_rw2, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw2");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_rw2");
        } else {
          current_statement__ = 3;
          assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0),
            "assigning variable sigma_rw2");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> Rt;
      Rt = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
      stan::math::fill(Rt, DUMMY_VAR__);
      
      current_statement__ = 4;
      assign(Rt, nil_index_list(), rep_matrix(0.0, m, n),
        "assigning variable Rt");
      Eigen::Matrix<local_scalar_t__, -1, 1> xbeta;
      xbeta = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(xbeta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> y_;
      y_ = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(y_, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> loglik;
      loglik = Eigen::Matrix<local_scalar_t__, -1, -1>(n, 2);
      stan::math::fill(loglik, DUMMY_VAR__);
      
      current_statement__ = 12;
      if (logical_gt(k_fixed, 0)) {
        current_statement__ = 10;
        assign(xbeta, nil_index_list(), multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 8;
        assign(xbeta, nil_index_list(), rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 13;
      assign(y_, nil_index_list(), subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 21;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 16;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 14;
          assign(Rt,
            cons_list(index_uni(i),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw1,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw1") *
                sigma_rw1[(i - 1)]), 2), "assigning variable Rt");}
        current_statement__ = 19;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 17;
          assign(Rt,
            cons_list(index_uni((k + i)),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw2,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw2") *
                sigma_rw2[(i - 1)]), 2), "assigning variable Rt");}}
      current_statement__ = 22;
      assign(loglik, nil_index_list(),
        glm_approx_loglik(y_, y_miss, a1, P1, Ht, Tt, Rt, xreg_rw,
          distribution, u, y_original, xbeta, pstream__),
        "assigning variable loglik");
      {
        current_statement__ = 113;
        lp_accum__.add(
          normal_lpdf<propto__>(beta_fixed, beta_fixed_mean, beta_fixed_sd));
        current_statement__ = 114;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_rw1, sigma_rw1_shape, sigma_rw1_rate));
        current_statement__ = 115;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_rw2, sigma_rw2_shape, sigma_rw2_rate));
        current_statement__ = 116;
        lp_accum__.add(
          sum(
            rvalue(loglik,
              cons_list(index_multi(obs_idx),
                cons_list(index_min_max(1, 2), nil_index_list())), "loglik")));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_walker_glm_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<double, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta_fixed = in__.vector(k_fixed);
      std::vector<double> sigma_rw1;
      sigma_rw1 = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw1");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0),
          "assigning variable sigma_rw1");}
      std::vector<double> sigma_rw2;
      sigma_rw2 = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw2");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0),
          "assigning variable sigma_rw2");}
      Eigen::Matrix<double, -1, -1> Rt;
      Rt = Eigen::Matrix<double, -1, -1>(m, n);
      stan::math::fill(Rt, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> xbeta;
      xbeta = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(xbeta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_;
      y_ = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y_, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> loglik;
      loglik = Eigen::Matrix<double, -1, -1>(n, 2);
      stan::math::fill(loglik, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
        vars__.emplace_back(beta_fixed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        vars__.emplace_back(sigma_rw1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        vars__.emplace_back(sigma_rw2[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 4;
      assign(Rt, nil_index_list(), rep_matrix(0.0, m, n),
        "assigning variable Rt");
      current_statement__ = 12;
      if (logical_gt(k_fixed, 0)) {
        current_statement__ = 10;
        assign(xbeta, nil_index_list(), multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 8;
        assign(xbeta, nil_index_list(), rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 13;
      assign(y_, nil_index_list(), subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 21;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 16;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 14;
          assign(Rt,
            cons_list(index_uni(i),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw1,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw1") *
                sigma_rw1[(i - 1)]), 2), "assigning variable Rt");}
        current_statement__ = 19;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 17;
          assign(Rt,
            cons_list(index_uni((k + i)),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw2,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw2") *
                sigma_rw2[(i - 1)]), 2), "assigning variable Rt");}}
      current_statement__ = 22;
      assign(loglik, nil_index_list(),
        glm_approx_loglik(y_, y_miss, a1, P1, Ht, Tt, Rt, xreg_rw,
          distribution, u, y_original, xbeta, pstream__),
        "assigning variable loglik");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            vars__.emplace_back(
              rvalue(Rt,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "Rt"));}}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(xbeta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(y_[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            vars__.emplace_back(
              rvalue(loglik,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "loglik"));
          }}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> beta_rw;
      beta_rw = Eigen::Matrix<double, -1, -1>(k, beta_rw_2dim__);
      stan::math::fill(beta_rw, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> nu;
      nu = Eigen::Matrix<double, -1, -1>(k_rw2, nu_2dim__);
      stan::math::fill(nu, std::numeric_limits<double>::quiet_NaN());
      
      double weights;
      weights = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> y_fit;
      y_fit = Eigen::Matrix<double, -1, 1>(y_fit_1dim__);
      stan::math::fill(y_fit, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_rep;
      y_rep = Eigen::Matrix<double, -1, 1>(y_rep_1dim__);
      stan::math::fill(y_rep, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 28;
      assign(log_lik, nil_index_list(),
        add(
          rvalue(loglik,
            cons_list(index_omni(),
              cons_list(index_uni(1), nil_index_list())), "loglik"),
          rvalue(loglik,
            cons_list(index_omni(),
              cons_list(index_uni(2), nil_index_list())), "loglik")),
        "assigning variable log_lik");
      current_statement__ = 112;
      if (logical_eq(n_lfo, n)) {
        current_statement__ = 29;
        validate_non_negative_index("y_rep_j", "n", n);
        Eigen::Matrix<double, -1, 1> y_rep_j;
        y_rep_j = Eigen::Matrix<double, -1, 1>(n);
        stan::math::fill(y_rep_j, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 31;
        validate_non_negative_index("beta_j", "k", k);
        current_statement__ = 32;
        validate_non_negative_index("beta_j", "n", n);
        Eigen::Matrix<double, -1, -1> beta_j;
        beta_j = Eigen::Matrix<double, -1, -1>(k, n);
        stan::math::fill(beta_j, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 34;
        validate_non_negative_index("nu_j", "k_rw2", k_rw2);
        current_statement__ = 35;
        validate_non_negative_index("nu_j", "n", n);
        Eigen::Matrix<double, -1, -1> nu_j;
        nu_j = Eigen::Matrix<double, -1, -1>(k_rw2, n);
        stan::math::fill(nu_j, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 37;
        validate_non_negative_index("beta_array", "k", k);
        current_statement__ = 38;
        validate_non_negative_index("beta_array", "n", n);
        current_statement__ = 39;
        validate_non_negative_index("beta_array", "N", N);
        std::vector<std::vector<std::vector<double>>> beta_array;
        beta_array = std::vector<std::vector<std::vector<double>>>(k, std::vector<std::vector<double>>(n, std::vector<double>(N, std::numeric_limits<double>::quiet_NaN())));
        
        current_statement__ = 41;
        validate_non_negative_index("nu_array", "k_rw2", k_rw2);
        current_statement__ = 42;
        validate_non_negative_index("nu_array", "n", n);
        current_statement__ = 43;
        validate_non_negative_index("nu_array", "N", N);
        std::vector<std::vector<std::vector<double>>> nu_array;
        nu_array = std::vector<std::vector<std::vector<double>>>(k_rw2, std::vector<std::vector<double>>(n, std::vector<double>(N, std::numeric_limits<double>::quiet_NaN())));
        
        current_statement__ = 45;
        validate_non_negative_index("w", "N", N);
        Eigen::Matrix<double, -1, 1> w;
        w = Eigen::Matrix<double, -1, 1>(N);
        stan::math::fill(w, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 46;
        assign(w, nil_index_list(), rep_vector(0.0, N),
          "assigning variable w");
        current_statement__ = 89;
        for (int j = 1; j <= N; ++j) {
          current_statement__ = 49;
          for (int i = 1; i <= k_rw1; ++i) {
            current_statement__ = 47;
            assign(beta_j,
              cons_list(index_uni(i),
                cons_list(index_uni(1), nil_index_list())),
              normal_rng(beta_rw1_mean, beta_rw1_sd, base_rng__),
              "assigning variable beta_j");}
          current_statement__ = 53;
          for (int i = 1; i <= k_rw2; ++i) {
            current_statement__ = 50;
            assign(beta_j,
              cons_list(index_uni((k_rw1 + i)),
                cons_list(index_uni(1), nil_index_list())),
              normal_rng(beta_rw2_mean, beta_rw2_sd, base_rng__),
              "assigning variable beta_j");
            current_statement__ = 51;
            assign(nu_j,
              cons_list(index_uni(i),
                cons_list(index_uni(1), nil_index_list())),
              normal_rng(nu_mean, nu_sd, base_rng__),
              "assigning variable nu_j");}
          current_statement__ = 62;
          for (int t = 1; t <= (n - 1); ++t) {
            current_statement__ = 56;
            for (int i = 1; i <= k_rw1; ++i) {
              current_statement__ = 54;
              assign(beta_j,
                cons_list(index_uni(i),
                  cons_list(index_uni((t + 1)), nil_index_list())),
                normal_rng(
                  rvalue(beta_j,
                    cons_list(index_uni(i),
                      cons_list(index_uni(t), nil_index_list())), "beta_j"),
                  (rvalue(gamma_rw1,
                     cons_list(index_uni(i),
                       cons_list(index_uni(t), nil_index_list())),
                     "gamma_rw1") * sigma_rw1[(i - 1)]), base_rng__),
                "assigning variable beta_j");}
            current_statement__ = 60;
            for (int i = 1; i <= k_rw2; ++i) {
              current_statement__ = 57;
              assign(beta_j,
                cons_list(index_uni((k_rw1 + i)),
                  cons_list(index_uni((t + 1)), nil_index_list())),
                (rvalue(beta_j,
                   cons_list(index_uni((k_rw1 + i)),
                     cons_list(index_uni(t), nil_index_list())), "beta_j") +
                  rvalue(nu_j,
                    cons_list(index_uni(i),
                      cons_list(index_uni(t), nil_index_list())), "nu_j")),
                "assigning variable beta_j");
              current_statement__ = 58;
              assign(nu_j,
                cons_list(index_uni(i),
                  cons_list(index_uni((t + 1)), nil_index_list())),
                normal_rng(
                  rvalue(nu_j,
                    cons_list(index_uni(i),
                      cons_list(index_uni(t), nil_index_list())), "nu_j"),
                  (rvalue(gamma_rw2,
                     cons_list(index_uni(i),
                       cons_list(index_uni(t), nil_index_list())),
                     "gamma_rw2") * sigma_rw2[(i - 1)]), base_rng__),
                "assigning variable nu_j");}}
          current_statement__ = 65;
          for (int t = 1; t <= n; ++t) {
            current_statement__ = 63;
            assign(y_rep_j, cons_list(index_uni(t), nil_index_list()),
              normal_rng(
                dot_product(
                  rvalue(xreg_rw,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "xreg_rw"),
                  rvalue(beta_j,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "beta_j")),
                stan::math::sqrt(Ht[(t - 1)]), base_rng__),
              "assigning variable y_rep_j");}
          {
            current_statement__ = 66;
            validate_non_negative_index("states", "m", m);
            current_statement__ = 67;
            validate_non_negative_index("states", "n", n);
            Eigen::Matrix<double, -1, -1> states;
            states = Eigen::Matrix<double, -1, -1>(m, n);
            stan::math::fill(states, std::numeric_limits<double>::quiet_NaN());
            
            current_statement__ = 68;
            assign(states, nil_index_list(),
              glm_approx_smoother(subtract(y_, y_rep_j), y_miss, a1, P1, Ht,
                Tt, Rt, xreg_rw, pstream__), "assigning variable states");
            current_statement__ = 69;
            assign(beta_j, nil_index_list(),
              add(stan::model::deep_copy(beta_j),
                rvalue(states,
                  cons_list(index_min_max(1, k),
                    cons_list(index_min_max(1, n), nil_index_list())),
                  "states")), "assigning variable beta_j");
            current_statement__ = 71;
            if (logical_gt(k_rw2, 0)) {
              current_statement__ = 70;
              assign(nu_j, nil_index_list(),
                add(stan::model::deep_copy(nu_j),
                  rvalue(states,
                    cons_list(index_min_max((k + 1), m),
                      cons_list(index_min_max(1, n), nil_index_list())),
                    "states")), "assigning variable nu_j");
            } 
          }
          current_statement__ = 73;
          assign(beta_array,
            cons_list(index_min_max(1, k),
              cons_list(index_min_max(1, n),
                cons_list(index_uni(j), nil_index_list()))),
            to_array_2d(beta_j), "assigning variable beta_array");
          current_statement__ = 75;
          if (logical_gt(k_rw2, 0)) {
            current_statement__ = 74;
            assign(nu_array,
              cons_list(index_min_max(1, k_rw2),
                cons_list(index_min_max(1, n),
                  cons_list(index_uni(j), nil_index_list()))),
              to_array_2d(nu_j), "assigning variable nu_array");
          } 
          current_statement__ = 76;
          assign(w, cons_list(index_uni(j), nil_index_list()),
            -sum(
               rvalue(loglik,
                 cons_list(index_multi(obs_idx),
                   cons_list(index_uni(2), nil_index_list())), "loglik")),
            "assigning variable w");
          current_statement__ = 87;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 85;
            for (int t = 1; t <= n; ++t) {
              double xbeta_tmp;
              xbeta_tmp = std::numeric_limits<double>::quiet_NaN();
              
              current_statement__ = 82;
              xbeta_tmp = (xbeta[(t - 1)] +
                            dot_product(
                              rvalue(xreg_rw,
                                cons_list(index_omni(),
                                  cons_list(index_uni(t), nil_index_list())),
                                "xreg_rw"),
                              rvalue(beta_j,
                                cons_list(index_min_max(1, k),
                                  cons_list(index_uni(t), nil_index_list())),
                                "beta_j")));
              current_statement__ = 83;
              assign(w, cons_list(index_uni(j), nil_index_list()),
                (w[(j - 1)] +
                  (((y_original[(t - 1)] * xbeta_tmp) -
                     (u[(t - 1)] * stan::math::exp(xbeta_tmp))) +
                    ((0.5 * pow((y[(t - 1)] - xbeta_tmp), 2)) / Ht[(t - 1)]))),
                "assigning variable w");}
          } else {
            current_statement__ = 80;
            for (int t = 1; t <= n; ++t) {
              double xbeta_tmp;
              xbeta_tmp = std::numeric_limits<double>::quiet_NaN();
              
              current_statement__ = 77;
              xbeta_tmp = (xbeta[(t - 1)] +
                            dot_product(
                              rvalue(xreg_rw,
                                cons_list(index_omni(),
                                  cons_list(index_uni(t), nil_index_list())),
                                "xreg_rw"),
                              rvalue(beta_j,
                                cons_list(index_min_max(1, k),
                                  cons_list(index_uni(t), nil_index_list())),
                                "beta_j")));
              current_statement__ = 78;
              assign(w, cons_list(index_uni(j), nil_index_list()),
                (w[(j - 1)] +
                  (((y_original[(t - 1)] * xbeta_tmp) -
                     (u[(t - 1)] *
                       stan::math::log1p(stan::math::exp(xbeta_tmp)))) +
                    ((0.5 * pow((y[(t - 1)] - xbeta_tmp), 2)) / Ht[(t - 1)]))),
                "assigning variable w");}
          }}
        {
          int index;
          index = std::numeric_limits<int>::min();
          
          current_statement__ = 91;
          validate_non_negative_index("expw", "N", N);
          Eigen::Matrix<double, -1, 1> expw;
          expw = Eigen::Matrix<double, -1, 1>(N);
          stan::math::fill(expw, std::numeric_limits<double>::quiet_NaN());
          
          current_statement__ = 92;
          assign(expw, nil_index_list(), stan::math::exp(w),
            "assigning variable expw");
          current_statement__ = 93;
          weights = mean(expw);
          current_statement__ = 94;
          index = categorical_rng(divide(expw, sum(expw)), base_rng__);
          current_statement__ = 95;
          assign(beta_rw, nil_index_list(),
            to_matrix(
              rvalue(beta_array,
                cons_list(index_omni(),
                  cons_list(index_omni(),
                    cons_list(index_uni(index), nil_index_list()))),
                "beta_array")), "assigning variable beta_rw");
          current_statement__ = 97;
          if (logical_gt(k_rw2, 0)) {
            current_statement__ = 96;
            assign(nu, nil_index_list(),
              to_matrix(
                rvalue(nu_array,
                  cons_list(index_omni(),
                    cons_list(index_omni(),
                      cons_list(index_uni(index), nil_index_list()))),
                  "nu_array")), "assigning variable nu");
          } 
          current_statement__ = 109;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 107;
            for (int t = 1; t <= n; ++t) {
              current_statement__ = 104;
              assign(y_fit, cons_list(index_uni(t), nil_index_list()),
                (u[(t - 1)] *
                  stan::math::exp(
                    (xbeta[(t - 1)] +
                      dot_product(
                        rvalue(xreg_rw,
                          cons_list(index_omni(),
                            cons_list(index_uni(t), nil_index_list())),
                          "xreg_rw"),
                        rvalue(beta_rw,
                          cons_list(index_omni(),
                            cons_list(index_uni(t), nil_index_list())),
                          "beta_rw"))))), "assigning variable y_fit");
              current_statement__ = 105;
              assign(y_rep, cons_list(index_uni(t), nil_index_list()),
                poisson_rng(y_fit[(t - 1)], base_rng__),
                "assigning variable y_rep");}
          } else {
            current_statement__ = 102;
            for (int t = 1; t <= n; ++t) {
              double tmp;
              tmp = std::numeric_limits<double>::quiet_NaN();
              
              current_statement__ = 98;
              tmp = stan::math::exp(
                      (xbeta[(t - 1)] +
                        dot_product(
                          rvalue(xreg_rw,
                            cons_list(index_omni(),
                              cons_list(index_uni(t), nil_index_list())),
                            "xreg_rw"),
                          rvalue(beta_rw,
                            cons_list(index_omni(),
                              cons_list(index_uni(t), nil_index_list())),
                            "beta_rw"))));
              current_statement__ = 99;
              assign(y_fit, cons_list(index_uni(t), nil_index_list()),
                (tmp / (1.0 + tmp)), "assigning variable y_fit");
              current_statement__ = 100;
              assign(y_rep, cons_list(index_uni(t), nil_index_list()),
                binomial_rng(u[(t - 1)], y_fit[(t - 1)], base_rng__),
                "assigning variable y_rep");}
          }
        }
      } 
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_rw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_rw"));
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
          vars__.emplace_back(
            rvalue(nu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "nu"));}}
      vars__.emplace_back(weights);
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        vars__.emplace_back(y_fit[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        vars__.emplace_back(y_rep[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<double, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_fixed_flat__;
        current_statement__ = 1;
        assign(beta_fixed_flat__, nil_index_list(),
          context__.vals_r("beta_fixed"),
          "assigning variable beta_fixed_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 1;
          assign(beta_fixed, cons_list(index_uni(sym1__), nil_index_list()),
            beta_fixed_flat__[(pos__ - 1)], "assigning variable beta_fixed");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> sigma_rw1;
      sigma_rw1 = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(sigma_rw1, nil_index_list(), context__.vals_r("sigma_rw1"),
        "assigning variable sigma_rw1");
      std::vector<double> sigma_rw1_free__;
      sigma_rw1_free__ = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_rw1[(sym1__ - 1)], 0),
          "assigning variable sigma_rw1_free__");}
      std::vector<double> sigma_rw2;
      sigma_rw2 = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(sigma_rw2, nil_index_list(), context__.vals_r("sigma_rw2"),
        "assigning variable sigma_rw2");
      std::vector<double> sigma_rw2_free__;
      sigma_rw2_free__ = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_rw2[(sym1__ - 1)], 0),
          "assigning variable sigma_rw2_free__");}
      for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
        vars__.emplace_back(beta_fixed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        vars__.emplace_back(sigma_rw1_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        vars__.emplace_back(sigma_rw2_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta_fixed");
    names__.emplace_back("sigma_rw1");
    names__.emplace_back("sigma_rw2");
    names__.emplace_back("Rt");
    names__.emplace_back("xbeta");
    names__.emplace_back("y_");
    names__.emplace_back("loglik");
    names__.emplace_back("beta_rw");
    names__.emplace_back("nu");
    names__.emplace_back("weights");
    names__.emplace_back("y_fit");
    names__.emplace_back("y_rep");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_fixed)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw1)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m),
                                             static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n),
                                             static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(beta_rw_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw2),
                                             static_cast<size_t>(nu_2dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(y_fit_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(y_rep_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_fixed" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw2" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Rt" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbeta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "loglik" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_rw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "nu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "weights");
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_fit" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_fixed" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw2" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Rt" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbeta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "loglik" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_rw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "nu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "weights");
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_fit" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" << k_fixed << "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" << k_rw1 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" << k_rw2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" << m << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"matrix\",\"rows\":" << n << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << beta_rw_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" << k_rw2 << ",\"cols\":" << nu_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"weights\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" << y_fit_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << y_rep_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" << k_fixed << "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" << k_rw1 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" << k_rw2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" << m << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"matrix\",\"rows\":" << n << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << beta_rw_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" << k_rw2 << ",\"cols\":" << nu_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"weights\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" << y_fit_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << y_rep_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_walker_glm_namespace::model_walker_glm;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_walker_glm_namespace::profiles__;
}
#endif
#endif
