// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
#ifndef USE_STANC3
#define USE_STANC3
#endif
// Code generated by stanc v2.26.1
#include <stan/model/model_header.hpp>
namespace model_rw1_model_naive_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 18, column 2 to column 27)",
                                                      " (in 'string', line 19, column 2 to column 24)",
                                                      " (in 'string', line 20, column 2 to column 24)",
                                                      " (in 'string', line 23, column 2 to column 20)",
                                                      " (in 'string', line 25, column 2 to column 16)",
                                                      " (in 'string', line 26, column 2 to column 51)",
                                                      " (in 'string', line 28, column 4 to column 24)",
                                                      " (in 'string', line 29, column 4 to column 58)",
                                                      " (in 'string', line 27, column 16 to line 30, column 3)",
                                                      " (in 'string', line 27, column 2 to line 30, column 3)",
                                                      " (in 'string', line 33, column 2 to column 45)",
                                                      " (in 'string', line 34, column 2 to column 45)",
                                                      " (in 'string', line 35, column 2 to column 37)",
                                                      " (in 'string', line 37, column 15 to column 16)",
                                                      " (in 'string', line 37, column 4 to column 55)",
                                                      " (in 'string', line 38, column 4 to column 28)",
                                                      " (in 'string', line 36, column 2 to line 39, column 3)",
                                                      " (in 'string', line 2, column 2 to column 17)",
                                                      " (in 'string', line 3, column 2 to column 17)",
                                                      " (in 'string', line 4, column 9 to column 10)",
                                                      " (in 'string', line 4, column 12 to column 13)",
                                                      " (in 'string', line 4, column 2 to column 20)",
                                                      " (in 'string', line 5, column 9 to column 10)",
                                                      " (in 'string', line 5, column 2 to column 14)",
                                                      " (in 'string', line 6, column 9 to column 10)",
                                                      " (in 'string', line 6, column 2 to column 22)",
                                                      " (in 'string', line 7, column 9 to column 10)",
                                                      " (in 'string', line 7, column 2 to column 20)",
                                                      " (in 'string', line 8, column 9 to column 14)",
                                                      " (in 'string', line 8, column 2 to column 27)",
                                                      " (in 'string', line 9, column 9 to column 14)",
                                                      " (in 'string', line 9, column 2 to column 25)",
                                                      " (in 'string', line 12, column 9 to column 10)",
                                                      " (in 'string', line 12, column 2 to column 42)",
                                                      " (in 'string', line 13, column 9 to column 10)",
                                                      " (in 'string', line 13, column 2 to column 38)",
                                                      " (in 'string', line 14, column 2 to column 36)",
                                                      " (in 'string', line 15, column 2 to column 32)",
                                                      " (in 'string', line 18, column 24 to column 25)",
                                                      " (in 'string', line 20, column 9 to column 10)",
                                                      " (in 'string', line 20, column 12 to column 13)",
                                                      " (in 'string', line 23, column 9 to column 10)",
                                                      " (in 'string', line 23, column 12 to column 13)",
                                                      " (in 'string', line 25, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_rw1_model_naive final : public model_base_crtp<model_rw1_model_naive> {
 private:
  int k;
  int n;
  Eigen::Matrix<double, -1, -1> xreg;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, 1> beta_mean;
  Eigen::Matrix<double, -1, 1> beta_sd;
  Eigen::Matrix<double, -1, 1> sigma_mean;
  Eigen::Matrix<double, -1, 1> sigma_sd;
  Eigen::Matrix<double, -1, 1> sigma_b_mean;
  Eigen::Matrix<double, -1, 1> sigma_b_sd;
  double sigma_y_mean;
  double sigma_y_sd;
 
 public:
  ~model_rw1_model_naive() { }
  
  inline std::string model_name() const final { return "model_rw1_model_naive"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1", "stancflags = "};
  }
  
  
  model_rw1_model_naive(stan::io::var_context& context__,
                        unsigned int random_seed__ = 0,
                        std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_rw1_model_naive_namespace::model_rw1_model_naive";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 18;
      context__.validate_dims("data initialization","k","int",
          context__.to_vec());
      k = std::numeric_limits<int>::min();
      
      current_statement__ = 18;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 18;
      current_statement__ = 18;
      check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 19;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 19;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 20;
      validate_non_negative_index("xreg", "k", k);
      current_statement__ = 21;
      validate_non_negative_index("xreg", "n", n);
      current_statement__ = 22;
      context__.validate_dims("data initialization","xreg","double",
          context__.to_vec(k, n));
      xreg = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(xreg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 22;
        assign(xreg_flat__, nil_index_list(), context__.vals_r("xreg"),
          "assigning variable xreg_flat__");
        current_statement__ = 22;
        pos__ = 1;
        current_statement__ = 22;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 22;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 22;
            assign(xreg,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_flat__[(pos__ - 1)], "assigning variable xreg");
            current_statement__ = 22;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 23;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 24;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 24;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 24;
        pos__ = 1;
        current_statement__ = 24;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 24;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 24;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 25;
      validate_non_negative_index("beta_mean", "k", k);
      current_statement__ = 26;
      context__.validate_dims("data initialization","beta_mean","double",
          context__.to_vec(k));
      beta_mean = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_mean_flat__;
        current_statement__ = 26;
        assign(beta_mean_flat__, nil_index_list(),
          context__.vals_r("beta_mean"),
          "assigning variable beta_mean_flat__");
        current_statement__ = 26;
        pos__ = 1;
        current_statement__ = 26;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 26;
          assign(beta_mean, cons_list(index_uni(sym1__), nil_index_list()),
            beta_mean_flat__[(pos__ - 1)], "assigning variable beta_mean");
          current_statement__ = 26;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 27;
      validate_non_negative_index("beta_sd", "k", k);
      current_statement__ = 28;
      context__.validate_dims("data initialization","beta_sd","double",
          context__.to_vec(k));
      beta_sd = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta_sd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_sd_flat__;
        current_statement__ = 28;
        assign(beta_sd_flat__, nil_index_list(), context__.vals_r("beta_sd"),
          "assigning variable beta_sd_flat__");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 28;
          assign(beta_sd, cons_list(index_uni(sym1__), nil_index_list()),
            beta_sd_flat__[(pos__ - 1)], "assigning variable beta_sd");
          current_statement__ = 28;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 29;
      validate_non_negative_index("sigma_mean", "k + 1", (k + 1));
      current_statement__ = 30;
      context__.validate_dims("data initialization","sigma_mean","double",
          context__.to_vec((k + 1)));
      sigma_mean = Eigen::Matrix<double, -1, 1>((k + 1));
      stan::math::fill(sigma_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_mean_flat__;
        current_statement__ = 30;
        assign(sigma_mean_flat__, nil_index_list(),
          context__.vals_r("sigma_mean"),
          "assigning variable sigma_mean_flat__");
        current_statement__ = 30;
        pos__ = 1;
        current_statement__ = 30;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 30;
          assign(sigma_mean, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_mean_flat__[(pos__ - 1)], "assigning variable sigma_mean");
          current_statement__ = 30;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 31;
      validate_non_negative_index("sigma_sd", "k + 1", (k + 1));
      current_statement__ = 32;
      context__.validate_dims("data initialization","sigma_sd","double",
          context__.to_vec((k + 1)));
      sigma_sd = Eigen::Matrix<double, -1, 1>((k + 1));
      stan::math::fill(sigma_sd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_sd_flat__;
        current_statement__ = 32;
        assign(sigma_sd_flat__, nil_index_list(),
          context__.vals_r("sigma_sd"), "assigning variable sigma_sd_flat__");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 32;
          assign(sigma_sd, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_sd_flat__[(pos__ - 1)], "assigning variable sigma_sd");
          current_statement__ = 32;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 33;
      validate_non_negative_index("sigma_b_mean", "k", k);
      current_statement__ = 34;
      sigma_b_mean = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(sigma_b_mean, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 34;
      assign(sigma_b_mean, nil_index_list(),
        rvalue(sigma_mean, cons_list(index_min(2), nil_index_list()),
          "sigma_mean"), "assigning variable sigma_b_mean");
      current_statement__ = 35;
      validate_non_negative_index("sigma_b_sd", "k", k);
      current_statement__ = 36;
      sigma_b_sd = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(sigma_b_sd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 36;
      assign(sigma_b_sd, nil_index_list(),
        rvalue(sigma_sd, cons_list(index_min(2), nil_index_list()),
          "sigma_sd"), "assigning variable sigma_b_sd");
      current_statement__ = 37;
      sigma_y_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 37;
      sigma_y_mean = sigma_mean[(1 - 1)];
      current_statement__ = 38;
      sigma_y_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 38;
      sigma_y_sd = sigma_sd[(1 - 1)];
      current_statement__ = 39;
      validate_non_negative_index("sigma_b", "k", k);
      current_statement__ = 40;
      validate_non_negative_index("beta_raw", "k", k);
      current_statement__ = 41;
      validate_non_negative_index("beta_raw", "n", n);
      current_statement__ = 42;
      validate_non_negative_index("beta", "k", k);
      current_statement__ = 43;
      validate_non_negative_index("beta", "n", n);
      current_statement__ = 44;
      validate_non_negative_index("tmp", "k", k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += k;
      num_params_r__ += 1;
      num_params_r__ += k * n;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_rw1_model_naive_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> sigma_b;
      sigma_b = std::vector<local_scalar_t__>(k, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_b");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_b");
        } else {
          current_statement__ = 1;
          assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0),
            "assigning variable sigma_b");
        }}
      local_scalar_t__ sigma_y;
      sigma_y = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma_y = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma_y = stan::math::lb_constrain(sigma_y, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma_y = stan::math::lb_constrain(sigma_y, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<local_scalar_t__, -1, -1>(k, n);
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 3;
      beta_raw = in__.matrix(k, n);
      Eigen::Matrix<local_scalar_t__, -1, -1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, -1>(k, n);
      stan::math::fill(beta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(k);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 6;
      assign(beta,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        add(beta_mean,
          elt_multiply(beta_sd,
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta_raw"))),
        "assigning variable beta");
      current_statement__ = 10;
      for (int t = 2; t <= n; ++t) {
        current_statement__ = 7;
        assign(tmp, nil_index_list(),
          rvalue(beta,
            cons_list(index_omni(),
              cons_list(index_uni((t - 1)), nil_index_list())), "beta"),
          "assigning variable tmp");
        current_statement__ = 8;
        assign(beta,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          add(tmp,
            elt_multiply(to_vector(sigma_b),
              rvalue(beta_raw,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "beta_raw"))),
          "assigning variable beta");}
      {
        current_statement__ = 11;
        lp_accum__.add(
          normal_lpdf<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
        current_statement__ = 12;
        lp_accum__.add(
          normal_lpdf<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
        current_statement__ = 13;
        lp_accum__.add(normal_lpdf<propto__>(to_vector(beta_raw), 0, 1));
        {
          current_statement__ = 14;
          validate_non_negative_index("mu", "n", n);
          Eigen::Matrix<local_scalar_t__, 1, -1> mu;
          mu = Eigen::Matrix<local_scalar_t__, 1, -1>(n);
          stan::math::fill(mu, DUMMY_VAR__);
          
          current_statement__ = 15;
          assign(mu, nil_index_list(), columns_dot_product(xreg, beta),
            "assigning variable mu");
          current_statement__ = 16;
          lp_accum__.add(normal_lpdf<propto__>(y, mu, sigma_y));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_rw1_model_naive_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> sigma_b;
      sigma_b = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_b");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0),
          "assigning variable sigma_b");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y = in__.scalar();
      current_statement__ = 2;
      sigma_y = stan::math::lb_constrain(sigma_y, 0);
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      beta_raw = in__.matrix(k, n);
      Eigen::Matrix<double, -1, -1> beta;
      beta = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> tmp;
      tmp = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(tmp, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(sigma_b[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 6;
      assign(beta,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        add(beta_mean,
          elt_multiply(beta_sd,
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta_raw"))),
        "assigning variable beta");
      current_statement__ = 10;
      for (int t = 2; t <= n; ++t) {
        current_statement__ = 7;
        assign(tmp, nil_index_list(),
          rvalue(beta,
            cons_list(index_omni(),
              cons_list(index_uni((t - 1)), nil_index_list())), "beta"),
          "assigning variable tmp");
        current_statement__ = 8;
        assign(beta,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          add(tmp,
            elt_multiply(to_vector(sigma_b),
              rvalue(beta_raw,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "beta_raw"))),
          "assigning variable beta");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            vars__.emplace_back(
              rvalue(beta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "beta"));}
        }
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          vars__.emplace_back(tmp[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> sigma_b;
      sigma_b = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(sigma_b, nil_index_list(), context__.vals_r("sigma_b"),
        "assigning variable sigma_b");
      std::vector<double> sigma_b_free__;
      sigma_b_free__ = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_b[(sym1__ - 1)], 0),
          "assigning variable sigma_b_free__");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y = context__.vals_r("sigma_y")[(1 - 1)];
      double sigma_y_free__;
      sigma_y_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y_free__ = stan::math::lb_free(sigma_y, 0);
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 3;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 3;
            assign(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(sigma_b_free__[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y_free__);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("sigma_b");
    names__.emplace_back("sigma_y");
    names__.emplace_back("beta_raw");
    names__.emplace_back("beta");
    names__.emplace_back("tmp");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tmp" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "tmp" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" << k << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"tmp\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" << k << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"tmp\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_rw1_model_naive_namespace::model_rw1_model_naive;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rw1_model_naive_namespace::profiles__;
}
#endif
#endif
