% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/political.R
\name{political}
\alias{political}
\title{Generate Random Vector of Political Parties}
\usage{
political(n, x = c("Democrat", "Republican", "Constitution", "Libertarian",
  "Green"), prob = c(0.577269133302094, 0.410800432748879,
  0.00491084954793489, 0.00372590303330866, 0.0032936813677832),
  name = "Political")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of political party elements.
}
\description{
Generate a random vector of political parties.
}
\details{
The political parties and probabilities used match approximate U.S.
political make-up of registered voters (2014).  The default make up is:

\tabular{lrr}{
  \bold{ Party} \tab \bold{N} \tab \bold{Percent} \cr
  Democrat     \tab 43,140,758 \tab 57.73\% \cr
  Republican   \tab 30,700,138 \tab 41.08\% \cr
  Constitution \tab   367,000 \tab   .49\% \cr
  Libertarian  \tab   278,446 \tab   .37\% \cr
  Green        \tab   246,145 \tab   .33\% \cr
}
}
\examples{
political(10)
barplot(table(political(10000)))
}
\seealso{
Other variable functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{likert}}, \code{\link{lorem_ipsum}},
  \code{\link{marital}}, \code{\link{military}},
  \code{\link{month}}, \code{\link{name}},
  \code{\link{normal}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{democrat}
\keyword{political}
\keyword{politics}
\keyword{republican}
