% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasureBoot.R
\name{ineq.weighted}
\alias{ineq.weighted}
\title{ineq.weighted}
\usage{
ineq.weighted(
  X,
  W = rep(1, length(X)),
  Atkinson.e = 1,
  Jenkins.alfa = 0.8,
  Entropy.e = 0.5,
  Kolm.p = 1
)
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{Atkinson.e}{is a parameter for calculating the value of the Atkinson coefficient}

\item{Jenkins.alfa}{is the Jenkins coefficient parameter}

\item{Entropy.e}{is a entropy parameter}

\item{Kolm.p}{is a Kolm parameter}
}
\value{
The data frame with weighted mean and sum of X, and all inequality measures.
}
\description{
Calculates weighted mean and sum of X, and a set of inequality measures.
}
\examples{
X=c(1,2,3,4,5,6,7,8,9)
W=c(2,5,6,7,3,4,5,2,5)
ineq.weighted(X,W)

}
