% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_calendar_events.R
\name{get_calendar_events}
\alias{get_calendar_events}
\title{Get Calendar Events from Canvas LMS API}
\usage{
get_calendar_events(
  canvas,
  type = "event",
  start_date = NULL,
  end_date = NULL,
  undated = FALSE,
  all_events = FALSE,
  context_codes = NULL,
  excludes = NULL,
  includes = NULL,
  important_dates = FALSE,
  blackout_date = FALSE
)
}
\arguments{
\item{canvas}{A list containing the 'api_key' and 'base_url' for authentication.}

\item{type}{The type of events to retrieve. Default is "event". Allowed values: event, assignment.}

\item{start_date}{Only return events since the start_date (inclusive). Defaults to today.}

\item{end_date}{Only return events before the end_date (inclusive). Defaults to start_date.}

\item{undated}{Defaults to false (dated events only). If true, only return undated events and ignore start_date and end_date.}

\item{all_events}{Defaults to false (uses start_date, end_date, and undated criteria). If true, all events are returned, ignoring start_date, end_date, and undated criteria.}

\item{context_codes}{List of context codes of courses, groups, users, or accounts whose events you want to see. If not specified, defaults to the current user (i.e personal calendar, no course/group events).}

\item{excludes}{Array of attributes to exclude. Possible values are “description”, “child_events” and “assignment”.}

\item{includes}{Array of optional attributes to include. Possible values are “web_conference” and if calendar_series flag is on, “series_natural_language”.}

\item{important_dates}{Defaults to false. If true, only events with important dates set to true will be returned.}

\item{blackout_date}{Defaults to false. If true, only events with blackout date set to true will be returned.}
}
\value{
A data frame of calendar events retrieved from the Canvas LMS API.
}
\description{
Retrieve the paginated list of calendar events or assignments for the current user.
}
