% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_write.R
\name{vroom_write}
\alias{vroom_write}
\title{Write a data frame to a delimited file}
\usage{
vroom_write(x, path, delim = "\\t", na = "NA", col_names = !append,
  append = FALSE, quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"), bom = FALSE,
  num_threads = vroom_threads(), progress = vroom_progress())
}
\arguments{
\item{x}{A data frame to write to disk}

\item{path}{Path or connection to write to.}

\item{delim}{One of more characters used to delimiter fields within a
record. If \code{NULL} the delimiter is guessed from the set of \code{c(",", "\\t", " ", "|", ":", ";", "\\n")}.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{X1}, \code{X2} etc. Duplicate column names
will generate a warning and be made unique with a numeric prefix.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if file does not exist a new
file is created.}

\item{quote}{How to handle fields which contain characters that need to be quoted.
\itemize{
\item \code{needed} - Only quote fields which need them.
\item \code{all} - Quote all fields.
\item \code{none} - Never quote fields.
}}

\item{escape}{The type of escape to use when quotes are in the data.
\itemize{
\item \code{double} - quotes are escaped by doubling them.
\item \code{backslash} - quotes are escaped by a preceding backslash.
\item \code{none} - quotes are not escaped.
}}

\item{bom}{If \code{TRUE} add a UTF-8 BOM at the beginning of the file. This is
recommended when saving data for consumption by excel, as it will force
excel to read the data with the correct encoding (UTF-8)}

\item{num_threads}{Number of threads to use when reading and materializing vectors.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}
}
\description{
Write a data frame to a delimited file
}
\examples{
# If you only specify a file name, vroom_write() will write
# the file to your current working directory.
out_file <- tempfile(fileext = "csv")
vroom_write(mtcars, out_file, ",")

# You can also use a literal filename
# vroom_write(mtcars, "mtcars.tsv")

# If you add an extension to the file name, write_()* will
# automatically compress the output.
# vroom_write(mtcars, "mtcars.tsv.gz")
# vroom_write(mtcars, "mtcars.tsv.bz2")
# vroom_write(mtcars, "mtcars.tsv.xz")
}
