% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.funkmeans.R
\name{plot.funkmeans}
\alias{plot.funkmeans}
\title{Plotting of k-means clustering results for massively parallel smooths}
\usage{
\method{plot}{funkmeans}(x, fdobj = NULL, deriv = 0,
  ncluster = nrow(x$centers), new.array = TRUE, mfrow = NULL,
  colvec = NULL, cex.mtext = 0.7, xlabs = "", ylabs = "", titles = "",
  ...)
}
\arguments{
\item{x}{a functional k-means clustering object obtained from
\code{\link{funkmeans}}.}

\item{fdobj}{a functional data object, of class \code{"\link[fda]{fd}"},
defining the set of curves being clustered. By default, this is taken to be
\code{x$fdobj}; but if the latter is \code{NULL}, \code{fdobj} must be
specified. See the two cases in the example.}

\item{deriv}{which derivative to display in the plots, which show 30
randomly selected curves, along with the cluster center, from each cluster.
By default, the "0th derivative" is used (i.e., the curves themselves).}

\item{ncluster}{number of clusters to display.  By default, all are
displayed.}

\item{new.array}{logical: if \code{TRUE}, plots will be displayed in an
array whose dimensions are set by the \code{mfrow} argument.}

\item{mfrow}{a vector of length 2 giving the numbers of rows and columns for
the array of plots. By default, the number of rows will exceed the number of
columns by \code{0} or \code{1}, depending on \code{ncluster}.}

\item{colvec}{a vector of colors for the clusters. By default, this is set
to the first \code{ncluster} elements of \code{c("dodgerblue", "green",
"red", "orange", "yellow", "orchid",} \code{ "brown", "grey", "purple")}, if
\code{ncluster <= 9}.}

\item{cex.mtext}{magnification for mtext command to display the size of each
cluster above the corresponding subfigure.}

\item{xlabs,ylabs,titles}{?????\code{NULL} or a character vector of length 1
or \code{ncluster}, specifying titles (x axis, y axis, overall titles) for each
 cluster. If vector's length equals 1, each cluster plot has the same title.
 By default, it's \code{NULL}}

\item{...}{arguments passed to \code{\link[graphics]{plot}.}}
}
\description{
Visualization of functional k-means clustering as implemented by
\code{\link{funkmeans}}.
}
\examples{
data(test)
d4 = test$d4
x = test$x
semi.obj = semipar4d(d4, formula = ~sf(x), data = data.frame(x = x), lsp=-5:5)
myfdobj = extract.fd(semi.obj)

# Case 1: fd object is stored in funkmeans object...
fkmobj = funkmeans(myfdobj, ncomp = 8, centers = 6)
plot(fkmobj)

# Case 2: fd object is not stored...
fkmobj = funkmeans(myfdobj, ncomp = 8, centers = 6, store.fdobj=FALSE)
plot(fkmobj, myfdobj)
}
\author{
Yin-Hsiu Chen \email{enjoychen0701@gmail.com}, Philip Reiss
\email{phil.reiss@nyumc.org}, Lan Huo, and Ruixin Tan
}
\seealso{
\code{\link{funkmeans}}, \code{\link{funkpanel}}
}

