% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_multinom}
\alias{generate_multinom}
\title{Generate multinomial scores}
\usage{
generate_multinom(n_voters, n_candidates, max = 10, probs = 0)
}
\arguments{
\item{n_voters}{integer, the number of voters to generate scores for.}

\item{n_candidates}{integer,  The number of candidates to generate scores for.}

\item{max}{The maximum value of the  distribution, by default 10. It also corresponds to the sum of scores on all the candidates}

\item{probs}{A vector of size n_candidates corresponding to the parameters of the multinomial distribution. By default all values are equal to 1/n_candidates}
}
\value{
A matrix of scores with 'n_candidates' rows and 'n_voters' columns.
}
\description{
This function generates  discrete scores following a multinomial distribution on a given scale
}
\examples{
voting_situation <- generate_multinom(n_voters=10, n_candidates=3,  max=100, probs=c(0.5, 0.3, 0.2))
}
