% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diarize.R
\name{diarize}
\alias{diarize}
\title{Who spoke when?}
\usage{
diarize(
  fromWav,
  toRttm = NULL,
  autoDir = FALSE,
  pycall = "~/miniconda3/envs/pyvoice38/bin/python3.8"
)
}
\arguments{
\item{fromWav}{A directory/folder containing WAV files.}

\item{toRttm}{A directory/folder to write RTTM files. If the default \code{toRttm = NULL} is used, \code{'./voiceAudios/rttm'} is created and used.}

\item{autoDir}{Logical. Must the directories tree be created? Default: \code{FALSE}. See 'Details'.}

\item{pycall}{Python call.}
}
\value{
RTTM files in NIST standard. See 'voice::read_rttm'.
}
\description{
Diarization from WAV audios using 'Python's' 'pyannote-audio' library.
}
\details{
When \code{autoDir = TRUE}, the following directories are created: \code{'../mp3'},\code{'../rttm'}, \code{'../split'} and \code{'../musicxml'}. Use \code{getwd()} to find the parent directory \code{'../'}.
}
\examples{
\dontrun{
library(voice)

wavDir <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

voice::diarize(fromWav = unique(dirname(wavDir)), toRttm = tempdir())
dir(tempdir())
}
}
