% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wall.R
\name{getWallExecute}
\alias{getWallExecute}
\title{Returns a list of posts on a user wall or community wall}
\usage{
getWallExecute(owner_id = "", domain = "", offset = 0, count = 10,
  filter = "owner", extended = "", fields = "", progress_bar = FALSE,
  v = getAPIVersion())
}
\arguments{
\item{owner_id}{ID of the user or community that owns the wall. By default, current user ID. Use a negative value to designate a community ID.}

\item{domain}{User or community short address.}

\item{offset}{Offset needed to return a specific subset of posts.}

\item{count}{Number of posts to return (0 for all posts).}

\item{filter}{Filter to apply:
\itemize{
\item \strong{owner} - posts by the wall owner;
\item \strong{others} - posts by someone else;
\item \strong{all} - posts by the wall owner and others (default);
\item \strong{postponed} - timed posts (only available for calls with an access_token);
\item \strong{suggests} - suggested posts on a community wall.
}}

\item{extended}{1 - to return wall, profiles, and groups fields, 0 - to return no additional fields (default).}

\item{fields}{List of comma-separated words}

\item{progress_bar}{Display progress bar}

\item{v}{Version of API}
}
\value{
Returns a list of post objects.
If extended is set to 1, also returns the following:
\itemize{
\item \strong{wall} - Contains a list of post objects.
\item \strong{profiles} - Contains user objects with additional fields photo and online.
\item \strong{groups} - Contains community objects.
}
}
\description{
Returns a list of posts on a user wall or community wall
}
\examples{
\dontrun{
# get all posts from wall
wall <- getWallExecute(domain='spbrug', count=0, progress_bar=TRUE)
}
}

