% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_theme.R
\name{define_theme}
\alias{define_theme}
\title{Provides a simple wrapper for themes}
\usage{
define_theme(
  strata = NULL,
  fontsizes = NULL,
  fontfamily = "Helvetica",
  grid = FALSE,
  bg = "transparent",
  legend_position = NULL
)
}
\arguments{
\item{strata}{list containing the different strata and name:colour value pairs}

\item{fontsizes}{list containing the font sizes for different options}

\item{fontfamily}{string with the name of a supported font}

\item{grid}{boolean that specifies whether the grid should be drawn or not}

\item{bg}{string giving the colour for the background of the plot}

\item{legend_position}{string indicating the legend position}
}
\value{
Nested list with styling preferences for a ggplot object
}
\description{
This function collects several lists if they are present. If absent, reasonable defaults are used.
}
\examples{

theme <- visR::define_theme(strata = list("SEX" = list("F" = "red",
                                                       "M" = "blue"),
                                          "TRTA" = list("Placebo" = "cyan",
                                                        "Xanomeline High Dose" = "purple",
                                                        "Xanomeline Low Dose" = "brown")),
                            fontsizes = list("axis" = 12,
                                             "ticks" = 10,
                                             "legend_title" = 10,
                                             "legend_text" = 8),
                            fontfamily = "Helvetica",
                            grid = list("major" = FALSE,
                                        "minor" = FALSE),
                            bg = "transparent",
                            legend_position = "top")

}
