% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_visr.R
\name{AlignPlots}
\alias{AlignPlots}
\title{Align multiple ggplot graphs, taking into account the legend}
\usage{
AlignPlots(pltlist = NULL)
}
\arguments{
\item{pltlist}{A list of plots (TODO: provide more detail)}
}
\value{
List of \code{ggplot} with equal width.
}
\description{
This function aligns multiple \code{ggplot} graphs by making them the same width by taking into account the legend width.
}
\examples{
\donttest{
library(ggplot2)
library(gtable)
library(cowplot)

## create 2 graphs
p1 <- ggplot2::ggplot(adtte, ggplot2::aes(x = as.numeric(AGE), fill = "Age")) +
  ggplot2::geom_histogram(bins = 15)
p2 <- ggplot2::ggplot(adtte, ggplot2::aes(x = as.numeric(AGE))) +
 ggplot2::geom_histogram(bins = 15)

## default alignment does not take into account legend size
cowplot::plot_grid(plotlist = list(p1,p2), align = "none", nrow=2)

## Alignplots takes into account legend width
cowplot::plot_grid(plotlist = AlignPlots(pltlist = list(p1, p2)), align = "none", nrow=2)
}
}
\references{
\url{https://stackoverflow.com/questions/26159495/align-multiple-ggplot-graphs-with-and-without-legends}
}
